package LCM::SapHostAgentFunctions;

use strict;
use base qw(SDB::Install::Base);
use SDB::Install::Saphostagent qw( getSHAVersion getActiveSaphostexecDir getSaphostexecPath);
use SDB::Install::SysVars qw($path_separator $isWin);
use SDB::Install::System qw($plain_hostname_regex);
use LCM::ProcessExecutor;
use SDB::Install::Version;

sub new {
	my ( $class, $component, $logger ) = @_;
	my $self = {};
	bless( $self, $class );
	if(defined $component){
		$self->{_component} = $component;
	}else{
		$self->{logger} = $logger;
	}
    $self->{doNotSetLogLocation} = 0;
    $self->{doNotShowProgress} = 0;
    
	return $self;
}

sub isSapHostAgentAvailable
{
    my $self = shift();
	return undef if (! $self->isHostagentInstalled());

	$self->setDoNotSetLogLocation(1);
	$self->setDoNotShowProgress(1);
	my $rc = $self->_execSapHostAgentCommand(['-status'], 'Checking for running SAP Host Agent...', 'SAP Host Agent is not running or error occurred while checking.', 'saphostexec');
	$self->setDoNotSetLogLocation(0);
    $self->setDoNotShowProgress(0);
	return $rc;
}

#----------------------------------------------------------------------------
#
# Registers SAP Instance service.
#
# $_[0] - self
# $_[1] - SID on which the instance should run
# $_[2] - Instance number
# $_[3] - hostname on which the instance should run
#
sub registerInstanceService {
	my ( $self, $sid, $nr, $hostname ) = @_;

	my @args;
	push( @args, '-function RegisterInstanceService' );
	push( @args, '-sid ' . $sid );
	push( @args, '-nr ' . $nr );
	push( @args, '-saplocalhost ' . $hostname );

	# TODO: check if windows options are needed
	return $self->_execSapHostAgentCommand(\@args, "Registering Instance Service...", "Registration of the Instance Service failed");
}

sub restartSapHostAgent {
    my ( $self, $doNotSetLogLocation, $doNotShowProgress ) = @_;

    my @args;
    push( @args, '-restart' );
    $self->setDoNotSetLogLocation($doNotSetLogLocation);
    $self->setDoNotShowProgress($doNotShowProgress);
    return $self->_execSapHostAgentCommand(\@args, "Restarting SAP Host Agent...", "Restart of SAP Host Agent failed.", 'saphostexec' );
}

sub _execSapHostAgentCommand
{
    my ($self, $argsArray, $startMessage, $failureMessage, $executable ) = @_;
    my $hostAgentExeDir = getActiveSaphostexecDir ();
    my $exe = (defined $executable) ? $executable : 'saphostctrl';
    my $ext = $isWin ? '.exe' : '';
    my $shaExe = $hostAgentExeDir . $path_separator . $exe . $ext;
    my $doNotSetLogLocation = $self->{doNotSetLogLocation};
    my $doNotShowProgress =  $self->{doNotShowProgress}; 
    # using LCM::ProcessExecutor instead of SDB::Install::Saphostagent for consistency
    my $exer = new LCM::ProcessExecutor ( $shaExe, $argsArray );
        $exer->quoteCmdLineArguments ( 0 );    # do not quote arguments as SHA cannot handle them
        my $rc;
    if(defined $self->{logger}){
    	$rc = $exer->execExtProgramLogging($self->{logger}, $startMessage,
        $failureMessage, $doNotShowProgress );
    }else{
    	$rc = $exer->execExtProgram ( $self->{_component}, $startMessage,
        $failureMessage, $doNotSetLogLocation, $doNotShowProgress );
    }


    return undef unless $rc;
    return wantarray() ? ($rc, $exer) : $rc;
}

sub isHostagentInstalled {
	my ($self) = @_;
	my $saphostexecPath = getSaphostexecPath();
	if (!defined $saphostexecPath) {
		my $hostAgentExeDir = getActiveSaphostexecDir();
		$self->setErrorMessage ("Cannot find installed SAP Host Agent at $hostAgentExeDir");
		return undef;
	}
	return 1;
}

sub setDoNotSetLogLocation{
	$_[0]->{doNotSetLogLocation} = $_[1];
}

sub setDoNotShowProgress{
	$_[0]->{doNotShowProgress} = $_[1];
}

1;