package LCM::Slpp::FileBrowser;

use strict;
use File::Spec;
use Cwd qw (realpath);
use LCM::Slpp::SlppAdapterFactory qw(createParameterAdapter);

my @SECURE_PATTERNS = (
	'^(/usr|/usr/local|/root)?/boot/',
	'^(/usr|/usr/local|/root)?/bin/',
	'^(/usr|/usr/local|/root)?/sbin/',
	'^(/usr|/usr/local|/root)?/etc/',
	'^(/usr|/usr/local|/root)?/lib/',
	'^(/usr|/usr/local|/root)?/sys/',
	'^/usr/sap/hostctrl/',
);

sub new {
	my $class = shift();
	my $self = bless({}, $class);
	$self->{_structure} = {
		type => 'string',
		value => undef,
		valid_values => [],
		ui_values => [],
	};
	$self->{_adapter} = createParameterAdapter('FileBrowser', $self->{_structure});
# Validation Status is set to 1 in order to disable the Default Table
	$self->{_adapter}->setValidationStatus(1);
	return $self;
}

sub setValue {
	my ($self, $value) = @_;
	my $values = [];
	eval{
		$values = $self->_getValues($self->_getParsedValue($value));
	};
	$self->{_structure}->{valid_values} = $values;
	$self->{_structure}->{ui_values} = $values;
}

sub _getValues{
	my ($self, $parsedValue) = @_;
	my @values = ();
	if(!$self->_isRestrictedPath($parsedValue) && opendir(my $dh, $parsedValue)){
		my @files = grep { $_ !~ /^\.|\.\.$/ } readdir($dh);
		closedir($dh);
		@values = grep { !$self->_isRestrictedPath($_) && (-l $_ || -d $_) } (map { File::Spec->catfile($parsedValue, $_) } @files);
	}
	return [ @values ];
}

sub _getParsedValue {
	my ($self, $inputValue) = @_;
	return $self->{_adapter}->parseInternalValue($inputValue->{Parameter});
}

sub _isRestrictedPath {
	my ($self, $value) = @_;
	$value = realpath($value);
	$value =~ s/\/?$/\//; # add slash at the end if not presented
	for my $securePattern (@SECURE_PATTERNS){
		return 1 if($value =~ m!$securePattern!);
	}
	return 0;
}

sub getSlppParameter {
	my ($self) = @_;
	return $self->{_adapter}->getSlppParameter();
}

1;