package LCM::Slpp::HdblcmModelFactory;

use strict;
use base qw(Exporter);
use  LCM::Slpp::TimeoutOptionAdapter;

our @EXPORT_OK = qw(createConfiguration createExecutor);

my %ACTION_TO_CONFIGURATION_MAPPING = (
	configure_sld				=> 'LCM::Configuration::SLD::RegistrationConfiguration',
	update_system				=> 'LCM::Configuration::Web::UpdateSystemConfiguration',
	update_components 			=> 'LCM::Configuration::Web::UpdateComponentsConfiguration',
	configure_internal_network	=> 'LCM::Configuration::Web::InternalNetworkConfiguration',
	detect_system_information	=> 'LCM::Configuration::Web::DetectSystemInformationConfiguration',
	add_hosts					=> 'LCM::Configuration::Hosts::AddHosts::AddRemoteHostsConfiguration',
	remove_hosts				=> 'LCM::Configuration::Hosts::RemoveHosts::Web::RemoveHostsConfiguration',
	uninstall_system			=> 'LCM::Configuration::Web::GenericStackUninstallation',
	optional_configuration_v1	=> 'LCM::Configuration::Web::FileBrowserConfiguration',
	optional_configuration_v3	=> 'LCM::Configuration::Web::AddHostRolesConfiguration',
	optional_configuration_v4	=> 'LCM::Configuration::Web::DownloadComponentsConfiguration',
	optional_configuration_v5	=> 'LCM::Configuration::Web::RemoveHostRolesConfiguration',
	optional_configuration_v6	=> 'LCM::Configuration::Web::ExtractComponentsConfiguration',
);

my %ACTION_TO_EXECUTOR_MAPPING = (
	configure_sld				=> 'LCM::Task::ConfigureSLDProcessTask',
	update_system				=> 'LCM::Task::GenericStackTask::UpdateProcessTask',
	update_components			=> 'LCM::Task::GenericStackTask::UpdateProcessTask',
	configure_internal_network	=> 'LCM::Task::ConfigureInternalNetworkProcessTask',
	detect_system_information	=> 'LCM::Executors::Web::DetectSystemInformationExecutor',
	add_hosts					=> 'LCM::Task::AddHostsUIProcessTask',
	remove_hosts				=> 'LCM::Task::RemoveHostsUIProcessTask',
	uninstall_system			=> 'LCM::Task::UninstallationProcessTask',
	optional_configuration_v1	=> 'LCM::Executors::Web::FileBrowserExecutor',
	optional_configuration_v3	=> 'LCM::Task::AddHostRolesUIProcessTask',
	optional_configuration_v4	=> 'LCM::Task::DownloadComponentsProcessTask',
	optional_configuration_v5	=> 'LCM::Task::RemoveHostRolesUIProcessTask',
	optional_configuration_v6	=> 'LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask',
);

sub createConfiguration {
	my ($action) = @_;

	if(exists $ACTION_TO_CONFIGURATION_MAPPING{$action}){
		my $configurationClass = $ACTION_TO_CONFIGURATION_MAPPING{$action};
		eval ("require $configurationClass;");
	    if ($@){
	        return undef;
	    }
		my $config = $configurationClass->new();
        addTimeouts($config);

		return $config;
	}
}

sub addTimeouts {
    my ($configuration) = @_;
    return if (defined $configuration->{params}->{Timeouts});
    return if (! defined($configuration->getTimeoutValues()));
    return if (! scalar(@{$configuration->getTimeoutValues()}));
    my $order = scalar(keys(%{$configuration->{params}})) + 1;
    my $section = "Timeouts";
    my $timeoutValues = $configuration->getTimeoutValues();
    my $timeOutsParam = {
        'order'             => $order,
        'opt'               => 'timeouts',
        'opt_arg'           => '<name>:<sec>',
        'section'           => $section,
        'opt_arg_switch'    => '<name%s>:<sec>',
        'type'              => 'mapping_list',
        'origin_values'     => $timeoutValues,
        'value'             => { map { ($_ => undef) } @{$timeoutValues} },
        'str'               => 'Timeouts',
        'mandatory'         => 0,
        'init_with_default' => 0,
        'set_interactive'   => 0,
    };

    $configuration->{params}->{Timeouts} = $timeOutsParam;
}

sub createExecutor {
	my ($action, $configuration, $progressHandler) = @_;

	if(exists $ACTION_TO_EXECUTOR_MAPPING{$action}){
		my $executorClass = $ACTION_TO_EXECUTOR_MAPPING{$action};
		eval "require $executorClass";
	    if ($@){
	        return undef;
	    }
		return $executorClass->new($configuration, $progressHandler, $progressHandler);
	}	
}

1;
