package LCM::Slpp::ParameterAdapter::MapParameter;

use strict;
use base qw(LCM::Slpp::ParameterAdapter::TableParameter);

sub getSlppBatchValue {
	my ($self) = @_;
	return $self->_getSlppValue(1);
}

sub getSlppValue {
	my ($self) = @_;
	return $self->_getSlppValue();
}

sub getValueByKey {
    my ($self, $key, $isBatchValue) = @_;
    my $hdblcmParameter = $self->{hdblcmRepresentation};
    my $values = undef;
    if ($isBatchValue) {
    	$values = $hdblcmParameter->{batchValue};
    } else {
    	$values = $hdblcmParameter->{value} // $hdblcmParameter->{default_map};
    }
    return $values->{$key};
}

sub getStructure {
	my ($self) = @_;
	my $paramId = $self->{parameterID};
	return  [
		{	Parameter => {
				id 		=> "key",
				type 	=> 'slp.parameter.type.SCALAR'
			},
		},
		{
			Parameter => {
				id 		=> "value",
				type 	=> 'slp.parameter.type.SCALAR'
			}
		}
	];
}

sub parseInternalValue {
	my ($self, $slppRepresentation, $isBatchValue) = @_;
	my $paramId = $self->{parameterID};
	
	my $tablevalue = $isBatchValue ? $slppRepresentation->{$self->getSlppBatchValueTag()} : $slppRepresentation->{$self->getSlppValueTag()};
	my $mappingList = {};
	for my $tupleHash (@$tablevalue) {
		my $paramsArray = $tupleHash->{Tuple}->{value};
		my $key = undef;
		my $value = undef;
		for my $parameter (@$paramsArray) {
			if ($parameter->{Parameter}->{id} eq "key") {
				$key = $parameter->{Parameter}->{value};
			} elsif ($parameter->{Parameter}->{id} eq "value") {
				$value = $parameter->{Parameter}->{value};
			}
		}
		
		$mappingList->{$key} = $value;
	}
	
	return $mappingList;
}

sub _getSlppValue {
	my ($self, $batchValue) = @_;
	my $hdblcmParameter = $self->{hdblcmRepresentation};
	my $valueTemplate = [];
	my $values = $batchValue ? $hdblcmParameter->{batchValue} : ($hdblcmParameter->{value} // $hdblcmParameter->{default_map});
	my $availableKeys = $hdblcmParameter->{origin_values} // [ keys %{$values} ];

	for my $key (@{$availableKeys}) {
		my $tuple = {
			Tuple => {
				id		=> $self->_getTupleIdByKey($key),
				value	=> [
						{
							Parameter => {
								id		=> "key",
								value	=> $key
							}
						},
						{	Parameter => {
								id		=> "value",
								value	=> $self->getValueByKey($key, $batchValue)
							}
						}
				]
			}
		};
		push(@{$valueTemplate}, $tuple);
	}

	return $valueTemplate;
}

1;