package LCM::Slpp::PersistenceHandler;

use strict;
use LCM::Slpp::Serializer qw(serialize);
use SDB::Install::SysVars qw($isWin);
use File::Spec;
use File::Copy;

sub new {
	my ($class, $adapter, $webResourcesDir, $logHandler) = @_;
	my $self = {
		logHandler => $logHandler,
		_adapter => $adapter,
		_webResourcesDir => $webResourcesDir,
	};
	
	return bless($self, $class);
}

sub getAdapter { return $_[0]->{_adapter}; }

sub getWebResourcesDir { return $_[0]->{_webResourcesDir}; }

sub getExecutionTasksStatusHash { return $_[0]->{_executionTasksStatusHash}; }

sub persistSlpState {
	my ($self) = @_;
	my $slppAdapter = $self->getAdapter();
	my $filesToPersist = {
		monitor 	=> 	serialize($slppAdapter->getSlppMonitor()),
		tasklist 	=> 	serialize($slppAdapter->getSlppTasklist()),
		config 		=>	serialize($slppAdapter->getParameters()),
		logs 		=>	serialize($slppAdapter->getLogs()),
		error 		=>	serialize($slppAdapter->getSlppError()),
	};
	
	my $webResourcesDir = $self->getWebResourcesDir();
	for my $file (keys %{$filesToPersist}) {
		my $fileContent = $filesToPersist->{$file};
		my $fileName = File::Spec->catfile($webResourcesDir, $file);
		open(my $fh, '>', $fileName);
		print $fh $fileContent;
		close $fh;
	    if ( !$isWin ) {
	        chmod(0755, $fileName);
		}
	}
}

sub copyLogFilesToResourcesDir {
	my ($self, $tasksInformation) = @_;
	my $logsDir = File::Spec->catdir($self->getWebResourcesDir(), 'log_files');

	if(!-d $logsDir && !mkdir($logsDir)){
		$self->{logHandler}->setErrorMessage("Failed to create directory '$logsDir':\n". $!);
		return;
	}
	if (!$isWin) {
		my (undef, undef, $mode) = stat($logsDir);
		chmod(0755 | $mode, $logsDir); # Try to ensure that we have propper permissions for that directory
	}
	for my $taskId (keys(%{$tasksInformation})) {
		my $logFileLocation = $tasksInformation->{$taskId}->{logLocation};
		my $logFileName = $tasksInformation->{$taskId}->{resourcesLogFilename};

#		No log file exists for this execution step
		next if(!$logFileLocation);

		my $destinationFile = File::Spec->catfile($logsDir, $logFileName);
		if(copy($logFileLocation, $destinationFile)){
			chmod(0640, $destinationFile);
			$self->{logHandler}->getMsgLst->addMessage("Copied log file '$logFileLocation' to '$destinationFile'.");
		} else {
			$self->{logHandler}->setErrorMessage("Failed to copy log file '$logFileLocation' to '$destinationFile' :\n" . $!);
		}
	}
}

sub cleanupFilesFromPreviousExecution {
	my ($self) = @_;
	
	my $webResourcesDir = $self->getWebResourcesDir();
	my @persitedSlppRESTResources = map { File::Spec->catfile($webResourcesDir, $_) } ('monitor', 'tasklist', 'config', 'logs', 'error');
	my $logsDir = File::Spec->catdir($webResourcesDir, 'log_files');
	my @slppLogFiles = ();
	
	if (-d $logsDir){
		my $dirHandle = undef;
		if(! opendir($dirHandle, $logsDir) ){
			$self->{logHandler}->getMsgLst()->addWarning("Failed to open directory '$logsDir': ". $!);
		}
		@slppLogFiles = map {File::Spec->catfile($logsDir, $_)} (readdir($dirHandle));
		closedir($dirHandle);
	}
	
	for my $filePath (@persitedSlppRESTResources, @slppLogFiles){
		next unless(-f $filePath); # do nothing if file does not exist
		
		if(! unlink($filePath) ){
			$self->{logHandler}->getMsgLst()->addWarning("Failed to delete file '$filePath': ". $!);
		} else {
			$self->{logHandler}->getMsgLst()->addMessage("Deleted file '$filePath'");
		}
	}
}

1;