package LCM::Slpp::SlppAdapterFactory;

use strict;
use base qw(Exporter);

our @EXPORT_OK = qw(createParameterAdapter);

my %PARAM_TYPE_TO_CLASS_MAPPING = (
	passwd 					=> 'LCM::Slpp::ParameterAdapter::PasswordParameter',
	initial_passwd 			=> 'LCM::Slpp::ParameterAdapter::PasswordParameter',
	boolean					=> 'LCM::Slpp::ParameterAdapter::BooleanParameter',
	path 					=> 'LCM::Slpp::ParameterAdapter::ScalarParameter',
	mapping_list 			=> 'LCM::Slpp::ParameterAdapter::MapParameter',
	mapping_listWithValidValues 			=> 'LCM::Slpp::ParameterAdapter::MapParameter',
	csv 					=> 'LCM::Slpp::ParameterAdapter::ScalarParameter',
	csvWithValidValues		=> 'LCM::Slpp::ParameterAdapter::MultipleSelectionParameter',
	number 					=> 'LCM::Slpp::ParameterAdapter::ScalarParameter',
	numberWithValidValues	=> 'LCM::Slpp::ParameterAdapter::SingleSelectionParameter',
	string 					=> 'LCM::Slpp::ParameterAdapter::ScalarParameter',
	stringWithValidValues 	=> 'LCM::Slpp::ParameterAdapter::SingleSelectionParameter',
);

sub createParameterAdapter {
	my ($paramId, $hdblcmRepresentation, $config) = @_;

    if($paramId eq 'Timeouts'){
       return LCM::Slpp::TimeoutOptionAdapter->new($paramId, $hdblcmRepresentation, $config); 
    }

	my $parameterType = $hdblcmRepresentation->{type};
	if ($hdblcmRepresentation->{valid_values}) {
		$parameterType = $parameterType . "WithValidValues";
	}

	if(exists $PARAM_TYPE_TO_CLASS_MAPPING{$parameterType}){
		my $parameterAdapterClass = $PARAM_TYPE_TO_CLASS_MAPPING{$parameterType};
		eval ("require $parameterAdapterClass;");
	    if ($@){
	        return undef;
	    }
		return $parameterAdapterClass->new($paramId, $hdblcmRepresentation);
	}
}

1;