package LCM::Slpp::Update::Listeners::SignatureVerificationSLPListener;

use strict;
use warnings;
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationListenerBase';
use SDB::Install::Globals qw($gFailedSignatureVerificationMessage $gSAPDSignerNotDetectedMessage);
use LCM::SAPDSigner;

sub new {
    return bless ({}, shift());
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    $instconfig->clearParameterWarnings('VerifySignature');
    return $self->SUPER::onValueChange($value, $instconfig);
}

sub handleVerificationFailure {
    my ($self, $instconfig) = @_;
    my $sapdsigner = LCM::SAPDSigner->getInstance();
    $instconfig->clearParameterWarnings('VerifySignature');
    $instconfig->addParameterWarning('VerifySignature', $self->getFailedVerificationMessage());
    return 1;
}

1;