package LCM::Slpp::Update::MediumComponentManager;

use strict;
use parent 'LCM::ComponentManager::MediumComponentManager';
use SDB::Install::SysVars qw($path_separator $isWin $currentPlatformName);

# Method is overriden to disable the addition of a server component
# in case of a resident update/install
sub addComponent{
    my ($self, $component) =  @_;

    if($self->isResidentComponentManager() && $component->isServer()){
    	return 1;
    }
    return $self->SUPER::addComponent($component);
}

# Method is overriden because we do not want to update the
# resident installer in case of a resident update/installation
sub _addResidentInstallerComponent {
	my $self = shift();
	if(!$self->isResidentComponentManager()){
		$self->SUPER::_addResidentInstallerComponent(@_);
	}
    return 1;
}

sub detectComponentsByFsRoot {
    my ($self,$rootPath) = @_;
   	my $manifestDirectories = $self->_findManifestDirectories($rootPath);
   	$self->{slppDetecedComponents} = [];
   	return $self->detectComponentsByDirectoryList($manifestDirectories, $self->{slppDetecedComponents});
}

sub detectComponentsByDVDRoot {
	my ($self,$dvdRootPath) = @_;
	$self->{slppDetecedComponents} = [];
    return $self->SUPER::detectComponentsByDVDRoot($dvdRootPath);
}

sub detectComponentsByDirectoryList {
    my ($self, $dirList) = @_;
    $self->{slppDetecedComponents} = [];
    return $self->SUPER::detectComponentsByDirectoryList($dirList, $self->{slppDetecedComponents});
}

sub detectComponentByManifestDir{
    my ($self, $manifestDir) = @_;
    return $self->SUPER::detectComponentByManifestDir($manifestDir, $self->{slppDetecedComponents});
}

sub _detectXS2ApplicationArchives {
    my ($self, $manifestDir) = @_;
    return $self->SUPER::_detectXS2ApplicationArchives($manifestDir, $self->{slppDetecedComponents});
}

sub _compileComponentList {
	my ($self) =  @_;
	my $msg = $self->getMsgLst()->addMessage ("Merging detected components");
	my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst(), undef]);
	my $warningMessage = "";
	$self->{isOnlyServerDetected} = 1;
	
	for my $component (@{$self->{slppDetecedComponents}}) {
		my $additionSuccessfull = $self->addComponent($component);
	    if (!$additionSuccessfull){
    	    $self->setErrorMessage ('Cannot add component', $self->getErrMsgLst());
        	$self->setMsgLstContext ($saveCntxt);
    	} else {
    	    my $warning = $self->hasDuplicatedComponentWarning($component);	
			$warningMessage .= $warning;
    	}
    	if ($component->isServer()){
			$self->{isServerDetected} = 1;
			next;
    	}
		$self->{isOnlyServerDetected} = 0;
	}

    if($warningMessage) {
    	$self->setWarningMessage($warningMessage);
    }
    
    my $rc = 0;
	if ($self->hasComponents()){
        $self->_addResidentInstallerComponent();
		$self->_addLMStructureComponent();
    } else {
    	$rc = $self->handleDetectionOfServer() ? 3 : 4;
	}
    
    return $rc;
}

sub isResidentComponentManager { return $_[0]->{isResidentComponentManager}; }

sub setResidentComponentManager { $_[0]->{isResidentComponentManager} = $_[1]; }

sub _shouldReturnIfDuplicateComponents {
	my ($self, $foundComponent, $newComponent, $keyName) = @_;
	my $addedComponentPath = $foundComponent->getPath();
    my $newComponentPath = $newComponent->getPath ();
    
    if($foundComponent->isServer()){
    	return $self->SUPER::_shouldReturnIfDuplicateComponents($foundComponent, $newComponent);
    }
    
    $self->getMsgLst()->addWarning("Component '$keyName' found in '$newComponentPath' is replaced by the one found in directory '$addedComponentPath'");
    return 0;
}

1;