package LCM::SummaryTreeBuilders::AddHostRolesSummaryTreeBuilder;

use strict;
use LCM::ComponentManager::SystemComponentManager;
use LCM::AdditionalHostHelper;
use SDB::Install::Globals qw (getHumanReadableRolesString);

sub buildSummaryTree {
    require LCM::SummaryTreeBuilder;

    my ($instconfig) = @_;

    my $roottext =  $instconfig->getProductName();
    my @rootChildren = ();

    my $summaryTree  = {
        "text"     => $roottext,
        "warnings" => [],
        "children" => \@rootChildren
    };

    push( @rootChildren, _buildOperationParamsNode($instconfig) );
    push( @rootChildren, _buildAdditionalRolesNode($instconfig) );

    if ( LCM::SummaryTreeBuilder::_shouldBuildAutoAddedXs2RolesNode($instconfig) ) {
        push( @rootChildren, LCM::SummaryTreeBuilder::_buildAutoAddedXs2RolesNode( $instconfig ));
    }
    return $summaryTree;
}

sub _buildOperationParamsNode {
    my ($instconfig)           = @_;
    my @operationParams        = ();

    my $operationParamsNodeRef = {
        "text" => "Add Host Roles Parameters",
        "children" => \@operationParams
    };

    my $param;
    for my $param_id ( @{ $instconfig->getParamIds() } ) {
        $param = $instconfig->{params}->{$param_id};
        if ( $param->{skip} ) {
            next;
        }

        if ( $param->{type} eq 'passwd' || $param->{type} eq 'initial_passwd' ) {
            next;
        }

        if( $param_id =~ /AddRoles|Target|SID/) {
            next;
        }

        if (! (defined $param->{hidden} && $param->{hidden}) ) {
            my $text = "$param->{str}: " . $instconfig->getLogValue($param_id);
            my $nodeRef = { "text" => $text };
            push( @operationParams, $nodeRef );
        }
    }

    return $operationParamsNodeRef;
}

sub _buildAdditionalRolesNode {
    my ($instconfig) = @_;

    my @hostsChildren = ();
    my $hostsNodeRef  = {
        "text"     => "Additional Host Roles",
        "children" => \@hostsChildren
    };
    my $ownInstance = $instconfig->getOwnInstance();
    my $mHostRolesInfo = $ownInstance->getHostRolesInfo();
    my $mAddRolesValue = $instconfig->getValue('AddRoles');

    foreach my $host (keys %$mAddRolesValue){
        my @hostChildren = ();
        my $originalRoles = join(',', split(' ', $mHostRolesInfo->{$host}));
        my $additionalRoles = $mAddRolesValue->{$host};
        next if (! defined $additionalRoles);

        push( @hostChildren, {text => "Current Role(s): " . $originalRoles});
        push( @hostChildren, {text => "Additional Role(s): " . $additionalRoles});
        my $hostNode = {
            "text"     => $host,
            "children" => \@hostChildren
        };
        push(@hostsChildren, $hostNode);
    }
    return $hostsNodeRef;
}

return 1;
