package LCM::Task::CheckInstallationTask::CheckInstallationProcessTask;

use strict;
use parent 'LCM::Task::SLProcessTask';

use LCM::Task qw($gFlavourProductName);
use LCM::Task::CheckInstallationTask::CheckInstallationTask;

my $TASK_NAME = "Check $gFlavourProductName Installation";
my $ACTION_DONE_MESSAGE = "$gFlavourProductName System checked.";
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = "$gFlavourProductName System check finished with warnings.";
my $ACTION_FAILED_MESSAGE = "$gFlavourProductName System check failed.";
my $ACTION_ABORTED_MESSAGE = "$gFlavourProductName System check aborted.";

sub new{
    my ($class, $configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    my $status = $self->getStatus();
    $status->_setActionDoneMessage($self->_formatMessage($ACTION_DONE_MESSAGE));
    $status->_setActionDoneWithWarningsMessage($self->_formatMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE));
    $status->_setActionFailedMessage($self->_formatMessage($ACTION_FAILED_MESSAGE));
    $status->_setActionAbortedMessage($self->_formatMessage($ACTION_ABORTED_MESSAGE));
    $self->addSubtask(new LCM::Task::CheckInstallationTask::CheckInstallationTask($configuration));
    return $self;
}

sub getId {
    return "check_installation";
}

sub getName {
    return $_[0]->_formatMessage($TASK_NAME);
}

1;