package LCM::Task::CommonTask::RemoveRemoteHostsTask;
use parent qw(LCM::Task::Hosts::HostsBaseTask);
use LCM::HostsParser qw(ExtractLocalAndRemoteHosts);
use strict;

use SDB::Install::Configuration::RemoveHost;

# Override
sub _buildArgs {
    my $self = shift();
    my $args = $self->SUPER::_buildArgs(@_);
    my $configuration = $self->_getConfiguration();
    my $removeHostsValue = $configuration->getValue("RemoveHosts");
    my ($localHostInputString, $remoteHostsInputString) = ExtractLocalAndRemoteHosts($removeHostsValue, $self->getMsgLst());
    push(@{$args}, "--removehosts=$remoteHostsInputString");
    if(!$configuration->isSkipped('RemoteExecution') && $configuration->hasValue('RemoteExecution')) {
        my $argument = sprintf('%s=%s', $configuration->getOpt('RemoteExecution'), $configuration->getValue('RemoteExecution'));
        push(@{$args}, $argument);
    }
    return $args;
}

sub getId {
    return 'remove_remote_hosts';
}

sub getSlppLogFileName {
    return 'remove_remote_hosts.log';
}

sub getName {
    return "Remove Remote Hosts";
}

sub _getTargetConfiguration {
    return new SDB::Install::Configuration::RemoveHost();
}

sub _getSHAOperation {
    return 'hdblcm_remove_hosts_v6';
}

sub _getExecutable {
    return 'hdbmodify';
}

sub getParameterToOptionMapping {
	my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $isUseSHA = $configuration->isUseSAPHostagent();
	return {
        'SID' => 'SID',
        'Target' => 'SAPMNT',
        'KeepXsUsers' => 'KXU',
        'KeepUser' => 'KEEP_USER',
        'SkipModifySudoers' => 'SUD',
        'ForceRemoveHosts' => 'FORCE',
        $isUseSHA ? ('RemoveHosts' => 'REMOVEHOSTS') : (),
        'KeepUserHomeDir' => 'KEEP_USER_HOME',
        'TenantUser'         => 'TENANT_USER',
        'AutoInitializeServices' => 'AIS',
    };
}

sub getExecutionName {
    return 'Removing Remote Hosts';
}

sub _getNumberOfExpectedOutputLines {
    return 100;
}

1;