package LCM::Task::CommonTask::RemoveRemoteXsControllerRolesTask;
use parent qw (LCM::Task::CommonTask::RemoveRemoteRolesTask);
use strict;

my $PROGRESS_MESSAGE        = 'Removing Remote XS Controller Host Roles';
our @EXPORT = qw ($PROGRESS_MESSAGE);

sub _getRemoteHostsRolesString {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $rolesMap = $configuration->getValue('RemoveRoles');
    my $originValues = $configuration->getParamOriginValues('RemoveRoles');
    my $xsControllerHost = $configuration->getOwnInstance()->getXsControllerHostname();

    my $result = [];
    for my $host (@{$originValues}) {
        next if ($host ne $xsControllerHost);
        next if (!exists($rolesMap->{$host}));

        my $isRemovingRoles = defined($rolesMap->{$host}) && length($rolesMap->{$host}) > 0;
        next if (! $isRemovingRoles);

        my @hostRoles = split(',', $rolesMap->{$host});
        my $hostRolesString = sprintf(':role=%s', join(':role=', @hostRoles));
        push(@{$result}, sprintf('%s%s', $host, $hostRolesString));
    }
    return join(',', @{$result});
}

sub getId {
    return 'remove_remote_xscontroller_roles';
}

sub getSlppLogFileName {
    return 'remove_remote_xscontroller_roles.log';
}

sub getName {
    return "Remove Specified Remote XS Controller Host Roles";
}

sub getExecutionName {
    return $PROGRESS_MESSAGE;
}

1;