package LCM::Task::CommonTask::UpdateComponentListOnLocalHostTask;

use strict;
use SDB::Install::SAPSystem;
use LCM::Landscape::LandscapeDescription;
use parent qw(LCM::Task::SHASupportedTask);
use LCM::Component qw(COMPONENT_NAME_LM_STRUCTURE);

my $PROGRESS_MESSAGE = 'Updating of Component List on Local Host';
our @EXPORT = qw ($PROGRESS_MESSAGE);

# Override
sub getId { return 'update_component_list_on_local_host'; }

# Override
sub getName { return "Update of Component List on Local Host"; }

# Override
sub getExecutionName { return $PROGRESS_MESSAGE; }

# Override
sub _getNumberOfExpectedOutputLines { return 100; }

# Override
sub _executeInternal {
    my $self = shift();
    my $configuration = $self->_getConfiguration();
    my $target = $configuration->getValue('Target');
    my $sid = $configuration->getValue('SID');
    my $sapSys = new SDB::Install::SAPSystem();

    $sapSys->initWithGlobDir($sid, $target);

    my $progressMessage = sprintf('Updating %s...', COMPONENT_NAME_LM_STRUCTURE());
    my $failedMessage = sprintf('Updating %s failed', COMPONENT_NAME_LM_STRUCTURE());
    my $message = $self->getMsgLst()->addProgressMessage($progressMessage);
    my $landscapeDescription = new LCM::Landscape::LandscapeDescription([$message->getSubMsgLst()], $sid, $sapSys);

    if(!$landscapeDescription->getErrMsgLst()->isEmpty()){
        $self->setErrorMessage(sprintf('%s failed', $self->getName()), $self->getErrMsgLst());
        $message->endMessage($failedMessage);
        $self->getStatus()->_setErrorState();
        return;
    }
    if(!$landscapeDescription->store()){
        $self->setErrorMessage(sprintf('%s failed', $self->getName()), $self->getErrMsgLst());
        $message->endMessage($failedMessage);
        $self->getStatus()->_setErrorState();
        return;
    }
    $message->endMessage();
    $self->getStatus()->_setFinishedState();
}

1;