package LCM::Task::CommonTask::UpdateComponentListTask;

use strict;
use File::Spec;
use LCM::Installer;
use LCM::Landscape::LandscapeDescription;
use parent qw(LCM::Task::SHASupportedTask);
use LCM::Component qw(COMPONENT_NAME_LM_STRUCTURE);

my $PROGRESS_MESSAGE = 'Updating of Component List';
our @EXPORT = qw ($PROGRESS_MESSAGE);

# Override
sub getId {
    return 'update_component_list';
}

# Override
sub getName {
    return "Update of Component List";
}

# Override
sub getExecutionName {
    return $PROGRESS_MESSAGE;
}

# Override
sub _getNumberOfExpectedOutputLines {
    return 100;
}

# Override
sub _executeInternal {
    my $self = shift();
    my $configuration = $self->_getConfiguration();
    my $sid = $configuration->getSID();
    my $isUpdate = $self->_isUpdatingLMStructure();
    my $progressMessage = ($isUpdate ? 'Updating ' : 'Creating ') . COMPONENT_NAME_LM_STRUCTURE() . '...';
    my $failedMessage = ($isUpdate ? 'Updating ' : 'Creating ') . COMPONENT_NAME_LM_STRUCTURE() . ' failed';
    my $message = $self->getMsgLst()->addProgressMessage($progressMessage);
    my $landscapeDescription = new LCM::Landscape::LandscapeDescription([$message->getSubMsgLst()], $sid);

    if(!$landscapeDescription->getErrMsgLst()->isEmpty()){
        $message->endMessage($failedMessage);
        $self->setErrorMessage(sprintf('%s failed', $self->getName()), $landscapeDescription->getErrMsgLst());
        $self->getStatus()->_setErrorState();
        return;
    }
    if(!$landscapeDescription->store()){
        $message->endMessage($failedMessage);
        $self->getStatus()->_setErrorState();
        return;
    }
    $message->endMessage();
    $self->getStatus()->_setFinishedState();
}

sub _isUpdatingLMStructure {
    my ($self) = @_;
    my $installer = new LCM::Installer();
    my $runtimeDir = $installer->getRuntimeDir();
    my $configuration = $self->_getConfiguration();
    my $target = $installer->isInstalled() ? File::Spec->catfile($runtimeDir, '..', '..') : $configuration->getValue('Target');

    return (-e File::Spec->catfile($target, 'lm_structure', 'landscapeDescription.xml')) ? 1 : undef;
}

1;