package LCM::Task::ComponentList::PrintComponentListTask;

use strict;
use parent 'LCM::Task';

sub getId {
    return "print_component_list_task";
}

sub getName {
    return "Print component list";
}

sub getExecutionName {
    return "Print component list";
}

sub _executeInternal {
    my ($self) = @_;
    my $instconfig = $self->_getConfiguration();
    my $ownSapSystem = $instconfig->getSAPSystem(1);

    if(!defined($ownSapSystem)){
        my $sid = $instconfig->getSID();
        $self->getErrMsgLst()->addError("No SAP system '$sid' found");
        $self->getStatus()->_setErrorState();
    } else {
        my $landscapeDescriptionXml = new LCM::Landscape::DescriptionXML($self->getMsgLstContext(), $ownSapSystem, 1);
        print($landscapeDescriptionXml->toString(1));
        $self->getStatus()->_setFinishedState();
    }
}

1;