package LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask;
use strict;
use warnings;
use SDB::Install::Globals qw($gKeynameEngine);
use SDB::Install::Sql::SqlConnectionProvider;
use SDB::Install::SAPInstance::NameserverUtility;
use parent qw(LCM::Task);

use constant SYSTEM_USER =>'SYSTEM';

sub new{
    my($class,$configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    return $self;
}

sub _executeInternal {
    my $self = shift();
    my $configuration = $self->_getConfiguration();
    my $message = $self->getMsgLst()->addProgressMessage($self->getProgressMessage());
    my $saveContext = $self->setMsgLstContext([$message->getSubMsgLst()]);
    my $progressHandler = $self->getMsgLst()->getProgressHandler();
    my $currentDepth = defined $progressHandler ? $progressHandler->getIntendationDepth() : 0;
    if(defined $progressHandler){
       $progressHandler->setIntendationDepth($currentDepth + 1);
    }
    
    my $isSuccess = $self->_executeConvertStep($configuration);
    $self->setServerState($self->getServerCurrentConversionState());
   
    $progressHandler->setIntendationDepth($currentDepth) if(defined $progressHandler);
    $message->endMessage(undef, $isSuccess ?  $self->getSuccessMessage() : $self->getFailedMessage());
    $self->setMsgLstContext($saveContext);
    $isSuccess ? $self->getStatus()->_setFinishedState() : $self->getStatus()->_setErrorState();
    $self->setErrorMessage($self->getFailedMessage() , $self->getErrMsgLst()) if(!$isSuccess);
}
sub getSuccessMessage{...}
sub getFailedMessage{...}
sub getProgressMessage{...}
sub getServerCurrentConversionState{...}
sub _executeConvertStep{...}
sub setServerState{
    my($self,$state) = @_;
    my $configuration = $self->_getConfiguration();
    my $server = $configuration->getSystemComponentManager()->getComponentByKeyName($gKeynameEngine);
    $server->setConvertToMultiDBState($state);
   
}
sub getComponent{
   my $self = shift;
   my $configuration = $self->_getConfiguration();
   my $server = $configuration->getSystemComponentManager()->getComponentByKeyName($gKeynameEngine);
   return $server; 
}

sub _createConnection{
    my($self,$host, $instanceNumber, $dbUser, $password, $trexInstance) = @_;
    $trexInstance->getGlobalIni (undef, 1);; #Bug 100669
    my $connectionProvider = new SDB::Install::Sql::SqlConnectionProvider();
    $connectionProvider->setMsgLstContext($self->getMsgLstContext());
    my $sql = $connectionProvider->getSqlConnection(
                $trexInstance->getSQLDatabaseName(),
                $trexInstance,
                $dbUser,
                $password);
    return $sql;
}

sub _runWrappedCommand {
    my ($self, $command, $arguments, $stdinLines, $isVerbose) = @_;
    my $configuration = $self->_getConfiguration();
    my $instance = $configuration->getOwnInstance();
    my $outputHandler = $isVerbose ? $self->getMsgLst()->getProgressHandler() : undef;
    my $msgLst = SDB::Install::MsgLst->new();
    my $exitCode  = $instance->runUtilityInEnv($command, $arguments, $msgLst, undef, $stdinLines,undef,$outputHandler,0, undef, undef, 1);
    $self->getMsgLst()->appendMsgLst($msgLst);
    return defined($exitCode) && $exitCode == 0 ? 1 : undef;
}
1;

