package LCM::Task::ConvertToMultiDBTask::ConvertStreamingTask;

use strict;
use warnings;
use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';
use SDB::Install::Globals qw ($gProductNameStreaming );
use SDB::Install::Configuration qw($bool_true_pattern);
use LCM::Component::Installed::HDBServer;
use File::Spec;
use File::Basename qw(dirname);

our $PROGRESS_MESSAGE = "Converting of $gProductNameStreaming...";
my $SUCCESS_END_MESSAGE = "Finished converting of $gProductNameStreaming";
my $FAIL_END_MESSAGE = "Converting of $gProductNameStreaming failed";

our @EXPORT = qw($PROGRESS_MESSAGE $ID);

sub getId {
    return 'convert_streaming';
}

sub getName {
    return "Converting of $gProductNameStreaming";
}

sub getExecutionName {
    return "Converting of $gProductNameStreaming";
}

sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE; 
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    my $isNoStartTennatDB =  0;
    if(defined $configuration->hasValue('NoStartTenantDB')){
        $isNoStartTennatDB = !$configuration->isSkipped('NoStartTenantDB') && $configuration->getValue('NoStartTenantDB')=~/$bool_true_pattern/;
    }
    my $isFinished = $isNoStartTennatDB;
    return $isFinished ? LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED : LCM::Component::Installed::HDBServer::CONVERT_MDC_STARTED;
}

sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $sapSystem = $configuration->getSAPSystem (1);
    my $trexInstance = $configuration->getOwnInstance();
    my $progressHandler = $self->getMsgLst()->getProgressHandler();
    if(defined $progressHandler){
       $sapSystem->SetProgressHandler   ($progressHandler);
       $trexInstance->SetProgressHandler($progressHandler);
    }
    return $self->_convertStreaming($configuration);
}

sub _convertStreaming{
    my ($self, $instconfig) = @_;
    my $dbUser = LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask::SYSTEM_USER;
    my $executable = $self->_createStrconverttomdcExecutable($instconfig);
    my $args = ['-hdbuser', $dbUser];
    my $stdinLines = [$instconfig->getValue ('SystemDBSQLPassword')];

    my $isSucess = $self->_runWrappedCommand($executable, $args, $stdinLines, 1, 0);
    return $isSucess;
}

sub _createStrconverttomdcExecutable{
    my ($self, $instconfig) = @_;
    my $sid = $instconfig->getSID();
    my $sapSystem = $instconfig->getSAPSystem (1);
    my $installationDirectory = $sapSystem->get_globalSidDir();
    my $strconverttomdc = File::Spec->catfile(dirname($installationDirectory),$sid, "streaming","hdblcm","strconverttomdc.sh");
    return $strconverttomdc;
}

sub _getNumberOfExpectedOutputLines {
    return 30;
}

sub initProgressHandler{
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}
1;