package LCM::Task::ConvertToMultiDBTask::DeployDUToMultiDBTask;

use strict;
use File::Spec;
use File::Basename;
use SDB::Install::NewDBUser;
use SDB::Install::SysVars qw($isWin);
use SDB::Install::System qw (isAdmin);
use SDB::Install::Configuration qw($bool_false_pattern $bool_true_pattern);
use LCM::ProcessExecutor;
use LCM::Installer;
use LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler;

use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';
use LCM::Component::Installed::HDBServer;

my $CONFIGURATION_NAME = 'system database';
my $PROGRESS_MESSAGE = "Importing delivery units to $CONFIGURATION_NAME...";
my $SUCCESS_END_MESSAGE = "Finished import of delivery units to $CONFIGURATION_NAME";
my $FAIL_END_MESSAGE = "Import of delivery units to $CONFIGURATION_NAME failed";

sub getId {
    return 'deploy_du_to_multidb_task';
}

sub getName {
    return 'Importing delivery units to system database';
}

sub getExecutionName {
    return 'Importing delivery units to system database';
}

sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE; 
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    my $isFinished =  !$configuration->isSkipped('NoStartTenantDB') && $configuration->getValue('NoStartTenantDB')=~/$bool_true_pattern/;
    return $isFinished ? LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED : LCM::Component::Installed::HDBServer::CONVERT_MDC_STARTED;
}

sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $sapSystem = $configuration->getSAPSystem (1);
    my $trexInstance = $configuration->getOwnInstance();
    my $progressHandler = $self->getMsgLst()->getProgressHandler();
    if(defined $progressHandler){
       $sapSystem->SetProgressHandler   ($progressHandler);
       $trexInstance->SetProgressHandler($progressHandler);
    }
    return $self->_deployDU($configuration,$trexInstance);
}

sub _configure {
    my ($self, $configuration) = @_;
    my $trexInstance = $configuration->getOwnInstance();
    $trexInstance->SetProgressHandler($self->getMsgLst()->getProgressHandler());

    if($isWin){ # Windows is currently not supported
        $self->setErrorMessage ('Windows currently not supported.', undef);
        return undef;
    }
    if(!$self->_deployDU($configuration, $trexInstance)){
        return undef;
    }
    
    return 1;
}

sub _createHdbupdrepExecutable{
    my ($self, $instconfig) = @_;
    my $sid = $instconfig->getSID();
    my $sapSystem = $instconfig->getSAPSystem(1);
    my $hdbupdrep = File::Spec->catfile($sapSystem->getUsrSapSid(),"SYS","global","hdb","install","bin","hdbupdrep");
    return $hdbupdrep;
}

sub _deployDU {
    my ($self, $instconfig, $trexInstance) = @_;
    my $progressHandler = $self->getMsgLst()->getProgressHandler();
    my $currentDepth = $progressHandler->getIntendationDepth();
    my $executable = $self->_createHdbupdrepExecutable($instconfig);
    my $args = [ '-b', '--read_password_from_stdin' ];
    my $stdinLines = [ $instconfig->getValue('SystemDBSQLPassword') ];

    $progressHandler->setIntendationDepth($currentDepth + 1);
    my $isSucess = $self->_runWrappedCommand($executable, $args, $stdinLines, 1, 1);
    $progressHandler->setIntendationDepth($currentDepth);

    if (!$isSucess){
        $self->getMsgLst()->addWarning('Deploying of DU failed',  $self->getMsgLst());
        return undef;
    }
    return 1;
}

sub _getNumberOfExpectedOutputLines {
    return 65;
}

sub initProgressHandler{
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}

1;