package LCM::Task::ConvertToMultiDBTask::StartTennantDatabaseTask;

use strict;
use warnings;
use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';
use SDB::Install::SAPInstance;
use LCM::Component::Installed::HDBServer;

my $SQL_STATEMENT_TEMPLATE = 'ALTER SYSTEM START DATABASE %s';

our $PROGRESS_MESSAGE = "Starting tenant database...";
my $SUCCESS_END_MESSAGE = "Finished starting tenant database";
my $FAIL_END_MESSAGE = "Starting tenant database failed";

our @EXPORT = qw($PROGRESS_MESSAGE $ID);

sub getId {
    return 'start_tennant_db';
}

sub getName {
    return 'Starting tenant database';
}

sub getExecutionName {
    return 'Starting tenant database';
}

sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE; 
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    return LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED;
}
sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $sapSystem = $configuration->getSAPSystem (1);
    my $trexInstance = $configuration->getOwnInstance();
    $trexInstance->setMsgLstContext ([$self->getMsgLst()]);
    return $self->_startTenantDatabase( $configuration,$trexInstance,);
}

sub _startTenantDatabase {
    my ($self, $configuration, $trexInstance) = @_;
    my $instanceNumber = $trexInstance->get_nr();
    my $sqlQuery = sprintf($SQL_STATEMENT_TEMPLATE, $configuration->getSID());
    my $password = $configuration->getValue ('SystemDBSQLPassword');
    my $host = $trexInstance->getSqlHost();
    my $dbUser =  LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask::SYSTEM_USER;
    my $connection=$self->_createConnection($host, $instanceNumber, $dbUser, $password, $trexInstance);
    if(defined $connection){
       my $msglst = $self->getMsgLst ();
       my $msg = $msglst->addMessage ("Performing SQL statement '$sqlQuery'");
       $connection->setMsgLstContext ([$msg->getSubMsgLst ()]);
       if (!defined $connection->execute ($sqlQuery)){
           $self->setErrorMessage("Sql execute failed", $connection->getErrMsgLst());
           $msglst->addWarning('Start of tenant database failed');
           return undef;
       }
       return 1;
    }
    return 0;
}

sub _getNumberOfExpectedOutputLines {
    return 30;
}

sub initProgressHandler{
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}

1;
