package LCM::Task::ConvertToMultiDBTask::StartXSAServicesTask;

use strict;
use LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler;
use LCM::Component::Installed::HDBServer;
use SDB::Install::SAPSystemXS2;
use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';

my  $XSA_SERVICES = ['xsexecagent', 'xscontroller', 'xsuaaserver'];
our $PROGRESS_MESSAGE = "Starting the XSA services...";
my  $SUCCESS_END_MESSAGE = "All XSA services started";
my  $FAIL_END_MESSAGE = "Starting the XSA services failed";

our @EXPORT = qw($PROGRESS_MESSAGE);

sub getId {
    return 'start_xsa_services_task';
}

sub getName {
    return 'Starting XSA services';
}

sub getExecutionName {
    return 'Starting XSA services';
}

sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE;
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    return LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED;
}

sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $serviceManager = SDB::Install::ServiceManager->new();
    my $msg = $self->getMsgLst()->addMessage("Starting ".(join ',', @{$XSA_SERVICES})." via the Service Manager ...");
    $serviceManager->setMsgLstContext([$msg->getSubMsgLst()]);

    if (!$serviceManager->enableServicesInDaemonIni($configuration, $XSA_SERVICES)) {
        $self->setErrorMessage("Couldn't enable the XSA services", $serviceManager->getErrMsgLst());
        return 0;
    }
    if (!$serviceManager->startServices($configuration, $XSA_SERVICES)) {
        $self->setErrorMessage("Couldn't start the XSA services", $serviceManager->getErrMsgLst());
        return 0;
    }

    return 1;
}

sub _getNumberOfExpectedOutputLines {
    return 50;
}

sub initProgressHandler {
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}

1;