package LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask;

use parent qw (LCM::Task::SLProcessTask);
use strict;

use LCM::Task::ExtractComponentsTask::ExtractComponentsTask;
use LCM::Task qw($gFlavourProductName);

my $ACTION_DONE_MESSAGE = "$gFlavourProductName Components successfully extracted";
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = "$gFlavourProductName Componenets extracted with warnings.";
my $ACTION_FAILED_MESSAGE = "$gFlavourProductName Components extraction failed.";
my $ACTION_ABORTED_MESSAGE = "Extraction of $gFlavourProductName Components aborted.";


sub new{
    my ($class, $configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    my $status = $self->getStatus();
    $status->_setActionDoneMessage($self->_formatMessage($ACTION_DONE_MESSAGE));
    $status->_setActionDoneWithWarningsMessage($self->_formatMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE));
    $status->_setActionFailedMessage($self->_formatMessage($ACTION_FAILED_MESSAGE));
    $status->_setActionAbortedMessage($self->_formatMessage($ACTION_ABORTED_MESSAGE));
    $self->addSubtask(new LCM::Task::ExtractComponentsTask::ExtractComponentsTask($configuration));
    return $self;
}

sub getId {
    return "extract_components";
}

sub getName {
    return "Extract components";
}

1;