package LCM::Task::GenericStackTask::CollectHDBServerPlugins;

use strict;
use parent 'LCM::Task';

sub getId {
	return 'collect_hdb_server_plugins';
}

sub getName{
	return 'Collect HDB Server Plugins';
}

sub getExecutionName{
	return 'Collecting HDB Server Plugins';
}

sub _executeInternal {
	my $self = shift;
	my $configuration = $self->_getConfiguration();
    $configuration->{plugins_list} = [];
    for my $component (@{ $self->getParentTask()->getSelectedComponents()}) {
        if($component->isServerPlugin() && (!$component->isUpdate() || $component->isUpdateToNewerVersion())){
            push @{$configuration->{plugins_list}}, $component->getComponentKeyName();
		}
        elsif(($component->isServer())&&
          $component->isUpdateToNewerVersion()){
            $configuration->{isServerUpdated} = 1;
        }
    }
    $self->getStatus()->_setFinishedState();
}    

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
	return 1;
}

sub shouldBeShownOnSummaryPage {
    return 0;
}

1;
