package LCM::Task::GenericStackTask::ComponentExecutionFailedHandler;

use strict;
use parent 'LCM::Task::BaseSubtaskFailedHandler';
use SDB::Install::Globals qw ($gKeynameInstaller $gKeynameLMStructure);
use LCM::Task::CommonTask::UpdateLocalHostTask qw($TASK_ID_UPDATE_LOCAL_HOST);
use LCM::Task::CommonTask::UpdateRemoteHostsTask qw($TASK_ID_UPDATE_REMOTE_HOSTS);

sub handle {
	my ($self, $task) = @_;
	my $parentTask = $task->getParentTask();
	my $installerKeyname = $gKeynameInstaller;
	my $taskIdInstall = "install_${installerKeyname}";
	my $taskIdUpdate = "update_${installerKeyname}";
	my $hdblcmComponentTask = $parentTask->getSubtaskById($taskIdUpdate) || $parentTask->getSubtaskById($taskIdInstall);
	my $lmStructureComponentName = $gKeynameLMStructure;
	my $isHdblcmUpdated = defined($hdblcmComponentTask) && $hdblcmComponentTask->getStatus()->isInFinishedState();

	$parentTask->getSubtasks(); # See implementation of getSubtasks in LCM::Task::GenericStackProcessTask
	for my $task ( @{ $parentTask->getAllSubtasks() } ) {
		if ( $task->getStatus()->isInInitialState() ) {
			next if($task->getId() eq $TASK_ID_UPDATE_LOCAL_HOST && $isHdblcmUpdated);
			next if($task->getId() eq $TASK_ID_UPDATE_REMOTE_HOSTS && $isHdblcmUpdated);
			next if($task->getId() =~ /\Q$lmStructureComponentName\E/);

			$task->setSkipped(1);
		}
	}
	return 1;
}

sub isApplicable {
	my ($self, $task) = @_;
    return 1 if $task->isComponentTask() && !$task->isServerComponentTask();
    return 0;
}

1;
