package LCM::Task::GenericStackTask::ComponentTask::ComponentPhasedTask;

use strict;
use parent qw ( LCM::Task::GenericStackTask::ComponentTask );

use  LCM::Component qw(PREPARE_PHASE ONLINE_PHASE OFFLINE_PHASE SYSTEM_ONLINE_PHASE);

sub new{
   my($class,$configuration,$component,$phase) = @_;
   my $self = $class->SUPER::new($configuration,$component);
   $self->_setPhase($phase);
   return $self;
}

sub getId{
	my $self = shift;
	return $self->_getPhase().'_'.$self->SUPER::getId();
}

sub getName{
    my $self = shift;
    my $component = $self->getComponent();
    my $componentName = $component->getComponentName();
    my $phase = $self->_getPhase();

    if($component->isUpdate()){
        if($phase eq PREPARE_PHASE){
            return "Prepare update of $componentName";
        }
        if($phase eq OFFLINE_PHASE){
            return "Update $componentName";
        }
        if($phase eq ONLINE_PHASE){
            return "Finalize update of $componentName";
        }
        if($phase eq SYSTEM_ONLINE_PHASE){
            return "Update content of $componentName";
        }
    } else {
        if($phase eq PREPARE_PHASE){
            return "Prepare installation of $componentName";
        }
        if($phase eq OFFLINE_PHASE){
            return "Install $componentName";
        }
        if($phase eq ONLINE_PHASE){
            return "Finalize installation of $componentName";
        }
        if($phase eq SYSTEM_ONLINE_PHASE){
            return "Install content of $componentName";
        }
    }
}

sub getExecutionName {
    my $self = shift;
    my $component = $self->getComponent();
    my $componentName = $component->getComponentName();
    my $phase = $self->_getPhase();

    if($component->isUpdate()){
        if($phase eq PREPARE_PHASE){
            return "Preparing update of $componentName";
        }
        if($phase eq OFFLINE_PHASE){
            return "Updating $componentName";
        }
        if($phase eq ONLINE_PHASE){
            return "Finalizing update of $componentName";
        }
        if($phase eq SYSTEM_ONLINE_PHASE){
            return "Updating content of $componentName";
        }
    } else {
        if($phase eq PREPARE_PHASE){
            return "Preparing installation of $componentName";
        }
        if($phase eq OFFLINE_PHASE){
            return "Installing $componentName";
        }
        if($phase eq ONLINE_PHASE){
            return "Finalizing installation of $componentName";
        }
        if($phase eq SYSTEM_ONLINE_PHASE){
            return "Installing content of $componentName";
        }
    }
}

sub _getPhase{
	my $self = shift;
	return $self->{_phase};
}

sub _setPhase{
	my ($self,$phase) = @_;
	$self->{_phase} = $phase;
}

sub _callComponentExecutable{
	my ($self) = @_;
	my $component = $self->getComponent();
    my $configuration = $self->_getConfiguration();
    $component->setPhase( $self->_getPhase() );
    return $component->isUpdate() ? $component->updateComponent($configuration) : $component->installComponent($configuration);
}

sub isResumable{
	my($self) = @_;
	if($self->_getPhase() eq PREPARE_PHASE){
		return 1;
	}
	return $self->SUPER::isResumable();
}

sub getLogLocation{
	my ($self) = @_;
	my $logLocation;
	my $component = $self->getComponent();
	my $phase = $self->_getPhase();

	if ($phase eq PREPARE_PHASE) {
		$logLocation = $component->getLogLocationForPreparePhase();
	} elsif ($phase eq OFFLINE_PHASE) {
		$logLocation = $component->getLogLocationForOfflinePhase();
	} elsif ($phase eq ONLINE_PHASE) {
		$logLocation = $component->getLogLocationForOnlinePhase();
	} elsif ($phase eq SYSTEM_ONLINE_PHASE) {
        $logLocation = $component->getLogLocationForSystemOnlinePhase();
    }

	if (defined $logLocation) {
		return $logLocation;
	}

	return $self->SUPER::getLogLocation();
}

1;
