package LCM::Task::GenericStackTask::ComponentTask::UninstallTask;

use strict;
use LCM::ExecutionWarningsObservable;
use LCM::Component qw(COMPONENT_NAME_LM_STRUCTURE);
use SDB::Install::Globals qw ($gKeynameLMStructure);
use parent 'LCM::Task::GenericStackTask::ComponentTask';

sub new {
	my ($class, $configuration, $component, $isFailureCritical) = @_;
	my $self = shift->SUPER::new($configuration, $component);
	$self->{isFailureCritical} = $isFailureCritical;
	$self->{indentationOffset} = 1;
	return $self;
}

# Override
sub getId {
	my $self = shift();
	my $component = $self->getComponent();
	my $componentKeyname = $component->getComponentKeyName();

	if($gKeynameLMStructure eq $componentKeyname){
		return 'update_'.$componentKeyname;
	}
	return 'uninstall_'.$componentKeyname;
}

# Override
sub getName {
	my $self = shift();
	my $component = $self->getComponent();
	my $componentName = $component->getComponentName();

	if($gKeynameLMStructure eq $component->getComponentKeyName()){
		return "Update $componentName";
	}
	return "Uninstall $componentName";
}

# Override
sub getExecutionName {
	my $self = shift();
	my $component = $self->getComponent();
	my $componentName = $component->getComponentName();

	if($gKeynameLMStructure eq $component->getComponentKeyName()){
		return "Updating $componentName";
	}
	return "Uninstalling $componentName";
}

# Override
sub isResumable{
	return 0;
}

# Override
sub _addListeners { }

# Override
sub _executeInternal {
	my $self = shift();
	my $component = $self->getComponent();
	my $configuration = $self->_getConfiguration();
	my $taskProgressHandler = $self->getMsgLst()->getProgressHandler();

	$component->setMsgLstContext($self->getMsgLstContext());
	$taskProgressHandler->setIntendationDepth($taskProgressHandler->getIntendationDepth()+$self->getIndentationOffset());
	$component->setProgressHandler($taskProgressHandler);

	LCM::ExecutionWarningsObservable->getInstance()->registerListener($self);

	if(! $component->uninstallComponent($configuration)){
		if (!$self->isCritical()) {
			my $componentName = $component->getComponentName();
			$self->_addWarningMessage("There were problems while uninstalling $componentName.");
		}
		$self->getStatus()->_setErrorState();
	} else {
		$self->getStatus()->_setFinishedState();
	}
	LCM::ExecutionWarningsObservable->getInstance()->unregisterListener($self);
}

sub isCritical {
	my ($self) = @_;
	my $isFailureCritical = $self->{isFailureCritical};
	return (defined $isFailureCritical) ? $isFailureCritical : 1;
}

sub getIndentationOffset {
	my ($self) = @_;
	return $self->{indentationOffset};
}

sub setIndentationOffset {
	my ($self, $offset) = @_;
	$self->{indentationOffset} = $offset;
}

1;