package LCM::Task::GenericStackTask::InstallProcessTask;

use strict;

use parent qw (LCM::Task::GenericStackProcessTask);
use LCM::Task::GenericStackTask::ServerInstallTaskFailedHandler;
use LCM::Task::GenericStackTask::ComponentExecutionFailedHandler;
use LCM::Task qw($gFlavourProductName $gActionScope);

my $INSTALL_SUCCESS_END_MESSAGE = "$gFlavourProductName $gActionScope installed";
my $INSTALL_FAIL_END_MESSAGE = "Installation of $gFlavourProductName $gActionScope failed.";
my $INSTALL_ABORT_END_MESSAGE = "Installation of $gFlavourProductName $gActionScope aborted.";
my $INSTALL_CHECK_SUCCESS_END_MESSAGE = "Installation checks for the $gFlavourProductName $gActionScope passed";
my $INSTALL_CHECK_FAIL_END_MESSAGE = "Installation checks for the $gFlavourProductName $gActionScope failed.";
my $INSTALL_CHECK_ABORT_END_MESSAGE = "Installation checks for the $gFlavourProductName $gActionScope aborted.";

sub getId {
    return 'install';
}

sub getName {
    return 'Install System and Components';
}

#Override
sub _isXsControllerExistingRemoteHost { return 0; }

sub _initActionMessages {
    my($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $status = $self->getStatus();
    if( $configuration->isCheckOnly()) {
        $status->_setActionDoneMessage($self->_formatMessage($INSTALL_CHECK_SUCCESS_END_MESSAGE));
        $status->_setActionDoneWithWarningsMessage('');
        $status->_setActionFailedMessage($self->_formatMessage($INSTALL_CHECK_FAIL_END_MESSAGE));
        $status->_setActionAbortedMessage($self->_formatMessage($INSTALL_CHECK_ABORT_END_MESSAGE));
    } else {
        $status->_setActionDoneMessage($self->_formatMessage($INSTALL_SUCCESS_END_MESSAGE));
        $status->_setActionDoneWithWarningsMessage('');
        $status->_setActionFailedMessage($self->_formatMessage($INSTALL_FAIL_END_MESSAGE));
        $status->_setActionAbortedMessage($self->_formatMessage($INSTALL_CHECK_ABORT_END_MESSAGE));
    }
}

sub isUpdate {
    return 0;
}

sub isResumable {
    return 0;
}

sub _createSubtasks {
    my $self = shift();

    $self->SUPER::_createSubtasks();

    my $configuration = $self->_getConfiguration();
    if(! $configuration->isCheckOnly()) {
        $self->addSubtaskFailedHandler(new LCM::Task::GenericStackTask::ServerInstallTaskFailedHandler());
        $self->addSubtaskFailedHandler(new LCM::Task::GenericStackTask::ComponentExecutionFailedHandler());
    }
}

1;
