package LCM::Task::GenericStackTask::PostOfflinePhaseTaskGenerator;
use parent 'LCM::Task::TaskGenerator';
use strict;

use LCM::Task::ConvertToMultiDBTask::ConvertToMultiDBTask;
use LCM::Task::ConvertToMultiDBTask::InitializeSystemUserInMultiDbTask;
use LCM::Utils::CommonUtils;

sub createTaskList{
    my($self, $configuration) = @_;
    my $result = [];
    my $isReplicationSystem = LCM::Utils::CommonUtils::isSystemReplication($configuration);
    if($configuration->isConvertToMultiDbRequired()){
        push(@$result,LCM::Task::ConvertToMultiDBTask::ConvertToMultiDBTask->new($configuration));
        if(!$isReplicationSystem){
            my $sytemUserPassword = $configuration->getValue ('SystemDBSQLPassword');

            if (defined $sytemUserPassword && $sytemUserPassword ne 'manager'){
                push(@$result,LCM::Task::ConvertToMultiDBTask::InitializeSystemUserInMultiDbTask->new($configuration));
            }
        }
    }
    return $result;
}

1;
