package LCM::Task::GenericStackTask::ServerInstallTaskFailedHandler;
use strict;
use parent 'LCM::Task::BaseSubtaskFailedHandler';
use SDB::Install::Globals qw ($gKeynameInstaller $gKeynameLMStructure);
use LCM::Task::CommonTask::UpdateRemoteHostsTask qw($TASK_ID_UPDATE_REMOTE_HOSTS);
use LCM::Task::CommonTask::UpdateLocalHostTask qw($TASK_ID_UPDATE_LOCAL_HOST);

sub handle {
	my ($self, $task) = @_;

	if(! $self->_doesServerManifestExist($task)){
		return 0;
	}

	my $parentTask = $task->getParentTask();
	my $componentKeynameInstaller = $gKeynameInstaller;
	my $lmStructureComponentName = $gKeynameLMStructure;

	$parentTask->getSubtasks(); # See implementation of getSubtasks in LCM::Task::GenericStackProcessTask
	for my $task(@{$parentTask->getAllSubtasks()}){
		if($task->getStatus()->isInInitialState()){
			next if($task->getId() eq $TASK_ID_UPDATE_LOCAL_HOST);
			next if($task->getId() eq $TASK_ID_UPDATE_REMOTE_HOSTS);
			next if($task->getId() =~ /^(install|update)_\Q$componentKeynameInstaller\E$/);
			next if($task->getId() =~ /\Q$lmStructureComponentName\E/);

			$task->setSkipped(1);
		}
	}
	return 1;
}

sub _doesServerManifestExist {
	my ( $self, $task ) = @_;
	my $configuration          = $task->_getConfiguration();
	my $instance = $configuration->getOwnInstance();

	return 0 if (!defined($instance));

	my $instanceExeDir         = $instance->get_instanceExeDir();
	my $manifestPath    = File::Spec->catfile( $instanceExeDir, 'manifest' );

	return length($instanceExeDir) > 0 && (-d $instanceExeDir) && (-e $manifestPath);
}

sub isApplicable{
	my ($self, $task) = @_;
	return $task->isComponentTask() && $task->isServerComponentTask();
}

1;