package LCM::Task::GenericStackTask::ServerUpdateTaskFailedHandler;
use strict;
use parent 'LCM::Task::BaseSubtaskFailedHandler';
use LCM::Task::CommonTask::UpdateRemoteHostsTask qw($TASK_ID_UPDATE_REMOTE_HOSTS);
use LCM::Task::CommonTask::UpdateLocalHostTask qw($TASK_ID_UPDATE_LOCAL_HOST);
use SDB::Install::Globals qw ($gKeynameEngine $gKeynameInstaller $gKeynameLMStructure);

sub handle {
	my ( $self, $task ) = @_;
	my $shouldSkipAllNextTasks = $self->_isHdbServerLinkSwitchedToNewerVersion($task) ? 0 : 1;

	$self->_skipNextTasks($task, $shouldSkipAllNextTasks);

	return 1;
}

sub _isHdbServerLinkSwitchedToNewerVersion {
	my ( $self, $task ) = @_;
	my $configuration = $task->_getConfiguration();
	my $mcm = $configuration->getComponentManager();
	my $detectedServer = $mcm->getComponentByKeyName($gKeynameEngine);
	my $detectedVersion = $detectedServer->getManifest()->getVersion();
	my $instanceExeDir = $configuration->getOwnInstance()->get_instanceExeDir();
	my $currentInstalledManifestPath = File::Spec->catfile( $instanceExeDir, 'manifest' );
	my $currentInstalledManifest = new SDB::Install::Manifest($currentInstalledManifestPath);
	my $currentInstalledVersion = $currentInstalledManifest->getVersion();

	return $detectedVersion eq $currentInstalledVersion;
}

sub _skipNextTasks {
	my ($self, $task, $skipAllTasks) = @_;
	my $parentTask = $task->getParentTask();
	my $componentKeynameInstaller = $gKeynameInstaller;
	my $lmStructureComponentName = $gKeynameLMStructure;

	$parentTask->getSubtasks(); # See implementation of getSubtasks in LCM::Task::GenericStackProcessTask
	for my $task(@{$parentTask->getAllSubtasks()}){
		if(!$task->getStatus()->isInInitialState()){
			next;
		}
		if ($skipAllTasks) {
			$task->setSkipped(1);
			next;
		}

		next if($task->getId() eq $TASK_ID_UPDATE_LOCAL_HOST);
		next if($task->getId() eq $TASK_ID_UPDATE_REMOTE_HOSTS);
		next if($task->getId() =~ /^(install|update)_\Q$componentKeynameInstaller\E$/);
		next if($task->getId() =~ /\Q$lmStructureComponentName\E/);

		$task->setSkipped(1);
	}
}

sub isApplicable{
    my ($self, $task) = @_;
    return $task->isComponentTask() && $task->isServerComponentTask();
}

1;
