package LCM::Task::Hosts::AddHosts::AddLocalHostTask;

use strict;
use LCM::ProcessExecutor;
use SDB::Install::SysVars qw($isWin);
use SDB::Install::Configuration::AddHost;
use parent qw(LCM::Task::Hosts::HostsBaseTask);
use SDB::Install::Globals qw($gLogDir);
use LCM::Task qw($gFlavourProductName);
use SDB::Install::Configuration qw($bool_true_pattern);

my $TASK_NAME = "Add Local Host to the $gFlavourProductName System";
my $PROGRESS_NAME = "Adding Local Host to the $gFlavourProductName System";

# Override
sub getId {
    return 'add_local_host';
}

# Override
sub getName {
    my ($self) = @_;
    return $self->_formatMessage($TASK_NAME);
}

# Override
sub getSlppLogFileName {
    return 'add_local_host.log';
}

# Override
sub getExecutionName {
    my ($self) = @_;
    return $self->_formatMessage($PROGRESS_NAME);
}

# Override
sub _getNumberOfExpectedOutputLines{
    return 100;
}

# Override
sub _buildArgs {
    my $self = shift();
    my $args = $self->SUPER::_buildArgs(@_);
    my $configuration = $self->_getConfiguration();
    my $addLocalHostConfiguration = $configuration->{localHostConfiguration};
    my @relevantLocalParameters = ('HostName', 'WorkerGroup', 'HostFailoverGroup', 'StoragePartitionNumber');
    if (! $configuration->isSkipped('AutoInitializeServices')) {
        push(@relevantLocalParameters, 'AutoInitializeServices');
    }
    if (! $configuration->isSkipped('TenantUser')){
        push(@relevantLocalParameters, 'TenantUser');
    }
    my $localArgs = $self->_buildCommandLineOptions($addLocalHostConfiguration, \@relevantLocalParameters);
    my $isAutoAssignEnabled = $configuration->getValue('AutoAddXS2Roles') && ! $configuration->isSkipped('AutoAddXS2Roles');
    my $hostRolesString = $addLocalHostConfiguration->getValue('HostRoles') || '';

    if (!$configuration->isSkipped('UseHttp') && $configuration->getValue('UseHttp')) {
        push(@{$args}, $configuration->getOpt('UseHttp'));
    }
    if($isAutoAssignEnabled){
        my $hostName =  $addLocalHostConfiguration->getValue('HostName');
        my $autoAssignedRolesMap = $configuration->getAutoAssignXs2RolesMap();
        my $autoAssignedRole = $autoAssignedRolesMap->{$hostName};
        $hostRolesString .= length($hostRolesString) > 0 ? ",$autoAssignedRole" : $autoAssignedRole;
    }
    push(@{$localArgs}, "--roles=$hostRolesString");

    return [ @{$args}, @{$localArgs} ];
}

# Override
sub _getTargetConfiguration {
    return new SDB::Install::Configuration::AddHost();
}

# Override
sub _getSHAOperation {
    # Local host cannot be added via SAP Host Agent
    return undef;
}

# Override
sub _getExecutable {
    return $isWin ? 'hdbaddhost.exe' : 'hdbaddhost';
}

# Override
sub getParameterToOptionMapping {
    return {
        'AutoInitializeServices' => 'AIS',
        'SystemUser'        => 'SYSTEM_USER',
        'TenantUser'        => 'TENANT_USER',
        'AcceleratorUser'   => 'ASE_USER',
        'OrgManagerUser'    => 'OMU',
        'SkipModifySudoers' => 'SUD',
        'NoStart'           => 'NO_START',
        'InstallHostagent'  => 'INSTALL_HOSTAGENT',
        'ImportContentXS2'  => 'IMPORT_XS_CONTENT',
    };
}

sub _buildCommandLineOptions {
    my ($self, $configuration, $parameterIds) = @_;
    my @addLocalHostParameterIds = grep{$_ ne 'RootUser'}@{$parameterIds};
    my $args = $self->SUPER::_buildCommandLineOptions($configuration,\@addLocalHostParameterIds);
    return $args;
}
1;