package LCM::Task::Hosts::AddHosts::AddRemoteHostsTask;

use strict;
use SDB::Install::SysVars qw($isWin);
use SDB::Install::Configuration::HdbModify;
use LCM::Component qw(parseLogFileLocation);
use parent qw(LCM::Task::Hosts::HostsBaseTask);
use LCM::HostsParser qw(ExtractLocalAndRemoteHosts);
use SDB::Install::Globals qw($gLogDir);
use LCM::Task qw($gFlavourProductName);
use SDB::Install::Configuration qw($bool_true_pattern);

my $TASK_NAME = "Add Remote Hosts to the $gFlavourProductName System";
my $PROGRESS_NAME = "Adding Remote Hosts to the $gFlavourProductName System";

# Override
sub getId {
    return 'add_remote_hosts';
}

# Override
sub getName {
    return $_[0]->_formatMessage($TASK_NAME);
}

# Override
sub getSlppLogFileName {
    return 'add_remote_hosts.log';
}

# Override
sub getExecutionName {
    return $_[0]->_formatMessage($PROGRESS_NAME);
}

# Override
sub _getNumberOfExpectedOutputLines{
    return 100;
}

# Override
sub _buildArgs {
    my $self = shift();
    my $args = $self->SUPER::_buildArgs(@_);
    my $configuration = $self->_getConfiguration();
    my $addHostsValue = $configuration->getValue("AddHosts");
    my ($localHostInputString, $remoteHostsInputString) = ExtractLocalAndRemoteHosts($addHostsValue, $self->getMsgLst());
    my $internalNetworkValue = $configuration->getValue('InternalNetwork');

    push(@{$args}, "--addhosts=$remoteHostsInputString");
    if(!$configuration->isSkipped('InternalNetwork') && defined($internalNetworkValue) && $internalNetworkValue ne 'none') {
        push(@{$args}, $configuration->getOpt('InternalNetwork') . '=' . $internalNetworkValue);
    }
    if(!$configuration->isSkipped('RemoteExecution') && $configuration->hasValue('RemoteExecution')) {
        my $argument = sprintf('%s=%s', $configuration->getOpt('RemoteExecution'), $configuration->getValue('RemoteExecution'));
        push(@{$args}, $argument);
    }
    if (!$configuration->isSkipped('UseHttp') && $configuration->getValue('UseHttp')) {
        push(@{$args}, $configuration->getOpt('UseHttp'));
    }
    return $args;
}

# Override
sub buildSHAOptionsMap {
    my $self = shift();
    my $configuration = $self->_getConfiguration();
    my $optionsMap = $self->SUPER::buildSHAOptionsMap(@_);
    my $internalNetworkValue = $configuration->getValue('InternalNetwork');

    if(!$configuration->isSkipped('InternalNetwork') && defined($internalNetworkValue) && $internalNetworkValue ne 'none') {
        $optionsMap->{INTERNAL_NETWORK} = $internalNetworkValue;
    }

    return $optionsMap;
}

# Override
sub _getTargetConfiguration {
    return new SDB::Install::Configuration::HdbModify();
}

# Override
sub _getSHAOperation {
    return 'hdblcm_add_hosts_v10';
}

# Override
sub _getExecutable {
    return $isWin ? 'hdbmodify.exe' : 'hdbmodify';
}

# Override
sub getParameterToOptionMapping {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $isUseSHA = $configuration->isUseSAPHostagent();

    return {
        'SID'               => 'SID',
        'Target'            => 'SAPMNT',
        (
            $isUseSHA ? ('AddHosts' => 'ADDHOSTS') : ()
        ),
        'AutoInitializeServices' => 'AIS',
        'ListenInterface'   => 'LI',
        'SkipModifySudoers' => 'SUD',
        'SystemUser'        => 'SU',
        'TenantUser'        => 'TU',
        'AcceleratorUser'   => 'ASE_USER',
        'InstallHostagent'  => 'INSTALL_HOSTAGENT',
        'OrgManagerUser'    => 'OMU',
        'NoStart'           => 'NO_START',
        'ImportContentXS2'  => 'IMPORT_XS_CONTENT',
        'SkipHostagentPw'   => 'SKIP_SHA_PASSWD',
        'AutoAddXS2Roles'   => 'AUTOADD_XS_ROLES',
        'UseHttp'           => 'USE_HTTP'
    };
}

1;
