package LCM::Task::Hosts::AddHosts::UpdateHostsTaskListFactory;

use strict;
use parent qw(LCM::Task::Hosts::BaseUpdateHostsTaskListFactory);
use LCM::SapHostAgentFunctions;
use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::LocalComponentsManager;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager;

sub new{
	my ($class, $configuration) = @_;
	my $self = $class->SUPER::new($configuration);
	return $self;
}

sub _shallDeploySHAConfigurations {
    my ($self, $checkDeployOnRemoteHosts) = @_;
    my $configuration = $self->getConfiguration();

    return 0 if ($configuration->shouldSkipHostagentCalls());

    my $shaHelper = new LCM::SapHostAgentFunctions();
    my $isSHAForInstall = $configuration->getValue("InstallHostagent");
    my $isSHAInstalledOnLocalHost = $shaHelper->isHostagentInstalled();
    my $willSHABeInstalled = $isSHAInstalledOnLocalHost || $isSHAForInstall;
    my $isAddingHosts = !$configuration->isSkipped('AddHosts') && $configuration->hasValue('AddHosts');

    return $checkDeployOnRemoteHosts ? ($isAddingHosts && $isSHAForInstall) : $willSHABeInstalled;
}

sub _shallSkipComponentsRemoteRegistration {
	my ($self) = @_;
	return ! $self->getRemoteComponentRegistrationManager->existRegistrableComponents();
}

sub _shallSkipComponentsLocalRegistration {
	my ($self) = @_;
	return ! $self->getLocalComponentRegistrationManager()->existRegistrableComponents();
}

sub _createUpdateLocalHostConfiguration {
	my ($self) = @_;
    my $configuration = $self->getConfiguration();
    my $localComponentRegistrationManager = $self->getLocalComponentRegistrationManager();
    $localComponentRegistrationManager->detectComponents();

    my $paramHash = {
        UpdateComponentListLocation => 0,
        ComponentsRegistration  => $self->_shallSkipComponentsLocalRegistration() ? 'none' : 'register',
        DeployShaConfigurations => $self->_shallDeploySHAConfigurations(),
        GenerateCertificates    => $configuration->isSkipped('CertificatesHostmap') ? 0 : 1,
        SkippedComponents       => $localComponentRegistrationManager->getSkippedComponents(),
    };
    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createLocalConfiguration($configuration, $paramHash);
}

sub _createUpdateRemoteHostConfiguration {
    my($self, $remoteHostsObjects) = @_;
    my $configuration = $self->getConfiguration();
    my $remoteComponentRegistrationManager = $self->getRemoteComponentRegistrationManager();
    $remoteComponentRegistrationManager->detectComponents();

    my $paramHash = {
        UpdateComponentListLocation => 0,
        DeployShaConfigurations     => $self->_shallDeploySHAConfigurations(1),
        SkippedComponents           => $remoteComponentRegistrationManager->getSkippedComponents(),
        GenerateCertificates        => $configuration->isSkipped('CertificatesHostmap') ? 0 : 1,
        ComponentsRegistration      => $self->_shallSkipComponentsRemoteRegistration() ? 'none' : 'register',
    };
    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createRemoteConfiguration($configuration, $remoteHostsObjects, $paramHash);
}

1;