package LCM::Task::Hosts::BaseUpdateHostsTaskListFactory;

use strict;
use parent qw (SDB::Install::Base Exporter);
use LCM::Task::CommonTask::UpdateLocalHostTask;
use LCM::Task::CommonTask::UpdateRemoteHostsTask;
use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::LocalComponentsManager;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::SkippedComponentsManager qw ($SCENARIO_ADD_REMOVE_HOSTS);

sub new{
	my ($class, $configuration) = @_;
	my $self = bless({}, $class);
	$self->_setConfiguration($configuration);
    $self->_initComponentsRegistrationManagers();
	return $self;
}

sub getConfiguration{
	return $_[0]->{_configuration};
}

sub _setConfiguration{
	my ($self, $configuration) = @_;
	$self->{_configuration} = $configuration;
}

sub _initComponentsRegistrationManagers {
    my($self) = @_;
    my $configuration = $self->getConfiguration();
    my $installedComponents;
    my $systemComponentManager = $configuration->getSystemComponentManager();
    if(defined $systemComponentManager){
        $installedComponents = $systemComponentManager->getAllComponents();
    }
    $self->setLocalComponentRegistrationManager(new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::LocalComponentsManager([], $installedComponents, $SCENARIO_ADD_REMOVE_HOSTS));
    $self->setRemoteComponentRegistrationManager(new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager([], $installedComponents, $SCENARIO_ADD_REMOVE_HOSTS));
}

sub getLocalComponentRegistrationManager{
	return $_[0]->{_localComponentRegistrationManager};
}

sub setLocalComponentRegistrationManager{
	my ($self, $localComponentRegistrationManager) = @_;
	$self->{_localComponentRegistrationManager} = $localComponentRegistrationManager;
}

sub getRemoteComponentRegistrationManager{
	return $_[0]->{_remoteComponentRegistrationManager};
}

sub setRemoteComponentRegistrationManager{
	my ($self, $remoteComponentRegistrationManager) = @_;
	$self->{_remoteComponentRegistrationManager} = $remoteComponentRegistrationManager;
}

sub createUpdateLocalHostTask {
    my($self) = @_;
    return new LCM::Task::CommonTask::UpdateLocalHostTask($self->_createUpdateLocalHostConfiguration());
}

sub createUpdateRemoteHostsTask {
    my($self, $remoteHostsObjects) = @_;
    return new LCM::Task::CommonTask::UpdateRemoteHostsTask($self->_createUpdateRemoteHostConfiguration($remoteHostsObjects));
}

1;