package LCM::Task::Hosts::RemoveHosts::RemoveLocalHostTask;
use parent qw(LCM::Task::Hosts::HostsBaseTask);
use strict;

use SDB::Install::Configuration::RemoveHost;
use LCM::Task qw($gFlavourProductName);

my $TASK_NAME = "Remove Local Host from $gFlavourProductName System";
my $PROGRESS_NAME = "Removing Local Host from $gFlavourProductName System";

# Override
sub getId {
    return 'remove_local_host';
}

# Override
sub getName {
    return $_[0]->_formatMessage($TASK_NAME);
}

# Override
sub getSlppLogFileName {
    return 'remove_local_host.log';
}

# Override
sub getExecutionName {
    return $_[0]->_formatMessage($PROGRESS_NAME);
}

# Override
sub _getNumberOfExpectedOutputLines{
    return 100;
}


# Override
sub _getTargetConfiguration {
    return new SDB::Install::Configuration::RemoveHost();
}

# Override
sub _getSHAOperation {
    # Local host cannot be removed via SAP Host Agent
    return undef;
}

# Override
sub _getExecutable {
    return 'hdbremovehost';
}

# Override
sub getParameterToOptionMapping {
    return {
        'SID'                => 'SID',
        'KeepUser'           => 'KEEP_USER',
        'KeepUserHomeDir'    => 'KEEP_USER_HOME',
        'KeepXsUsers'        => 'KXU',
        'SkipModifySudoers'  => 'SUD',
        'TenantUser'         => 'TENANT_USER',
        'AutoInitializeServices' => 'AIS',
    };
}

sub _buildCommandLineOptions {
    my ($self, $configuration, $parameterIds) = @_;
    my @removeLocalHostParameterIds = grep{$_ ne 'RootUser'}@{$parameterIds};
    my $args = $self->SUPER::_buildCommandLineOptions($configuration,\@removeLocalHostParameterIds);
    if ($configuration->isSystemInCompatibilityMode()) {
        push(@{$args}, '--addhost_compatiblity_mode=1');
    }
    return $args;
}
1;