package LCM::Task::RenameTask::DeletePersistenceFileTask;

use strict;
use parent qw(LCM::Task::SHASupportedTask);

my $PROGRESS_MESSAGE = 'Deleting Persistence File';
our @EXPORT = qw ($PROGRESS_MESSAGE);

# Override
sub getId {
    return 'delete_persistence_file';
}

# Override
sub getName {
    return "Delete Persistence File";
}

# Override
sub getExecutionName {
    return $PROGRESS_MESSAGE;
}

# Override
sub _getNumberOfExpectedOutputLines {
    return 100;
}

# Override
sub _executeInternal {
    my $self = shift();
    my $configuration = $self->_getConfiguration();
    return 1 if(!$configuration->{isContinueOption});
    
    $self->getMsgLst()->AddMessage($self->getExecutionName() . "..."); 
    if(!$self->_deletePersistenceFileIfNeeded($configuration)){
        $self->getStatus()->_setErrorState();
        $self->setErrorMessage(sprintf('%s failed', $self->getName()), $self->getErrMsgLst());
        return;
    }
    $self->getStatus()->_setFinishedState();
}

sub _deletePersistenceFileIfNeeded {
    my ( $self, $configuration) = @_;

    my $hdbInstance = $configuration->getOwnInstanceAfterRename();
    my $hostnameDir = $hdbInstance->get_hostNameDir();
    my $hdblcmPersistenceFilePath = File::Spec->catfile($hostnameDir, 'hdblcm_rename_system');
    
    return 1 if(! -f $hdblcmPersistenceFilePath);
    
    if(unlink($hdblcmPersistenceFilePath)){
        $self->getMsgLst()->AddMessage("Deleted status file'" . $hdblcmPersistenceFilePath . "'");
        return 1;
    }
    $self->getMsgLst()->AddWarning("Failed to delete status file'" . $hdblcmPersistenceFilePath . "'");
    return undef;
}

1;