package LCM::Task::RenameTask::UpdateLocalHostAfterRenameTask;

use strict;
use parent qw(LCM::Task::CommonTask::UpdateLocalHostTask);

use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;

sub new {
    my ($class, $configuration) = @_;
    my $configAfterRename = _createLocalConfigurationAfterRenameConfig($configuration);
    my $self = $class->SUPER::new($configAfterRename);
    return $self;
}

# Override
sub getId {
    return 'update_local_host_after_rename';
}

sub _createLocalConfigurationAfterRenameConfig{
    my ($configuration) = @_;
    my $sidAdmPassword = $configuration->getValue('Password');
    my $shallDeployShaConfigurations = ($configuration->shouldSkipHostagentCalls()) ? 0 : 1;
    my $paramHash = {
        ComponentsRegistration      => $configuration->shallReregisterComponents() ? 'register' : undef,
        GenerateCertificates        => !$configuration->skipRegenerationOnLocalhost(),
        DeployShaConfigurations     => $shallDeployShaConfigurations,
        UpdateComponentListLocation => 0,
    };
    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createLocalConfigurationAfterRename
                    ($sidAdmPassword, $configuration, $paramHash);
}

sub shouldBeShownOnSummaryPage {
    return 1;
}

1;