package LCM::Task::RenameTask::UpdateLocalHostBeforeRenameTask;

use strict;
use parent qw(LCM::Task::CommonTask::UpdateLocalHostTask);

use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;

sub new {
    my ($class, $configuration) = @_;
    my $configBeforeRename = _createUpdateLocalHostBeforeRenameConfig($configuration);
    my $self = $class->SUPER::new($configBeforeRename);
    return $self;
}

# Override
sub getId {
    return 'update_local_host_before_rename';
}

sub _createUpdateLocalHostBeforeRenameConfig {
    my ($configuration) = @_;
    my $paramHash = {
        ComponentsRegistration      => 'unregister',
        GenerateCertificates        => ($configuration->skipRegenerationOnLocalhost() ? 0 : 1),
        DeployShaConfigurations     => 0,
        UpdateComponentListLocation => 0,
    };    
    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createLocalConfigurationBeforeRename
                    ($configuration, $paramHash);
}

sub shouldBeShownOnSummaryPage {
    return 1;
}

1;