package LCM::Task::StartStopHostsTask::DisableAndStopSpecificServicesTask;
use parent qw(LCM::Task::StartStopHostsTask::StartStopSpecificServicesBase);
use strict;

use SDB::Install::ServiceManager;

sub getId {
	my ($self) = @_;
	return 'stop_services';
}

sub getName {
	my ($self) = @_;
	return 'Stop services';
}

sub getExecutionName {
	my ($self) = @_;
	return 'Stopping services';
}

sub _manageServices {
	my ($self) = @_;
	my $serviceManager = SDB::Install::ServiceManager->new();
	$serviceManager->setMsgLstContext($self->getMsgLstContext);
	my $config = $self->_getConfiguration();
	return undef if (!$serviceManager->disableServicesInDaemonIni($config, $self->getServices));
	if ($self->shouldRestartServices) {
		return $serviceManager->stopServices($config, $self->getServices());
	}
	return 1;
}

1;
