package LCM::Task::StartStopHostsTask::StopSpecificHostsTask;

use strict;

use parent 'LCM::Task::StartStopHostsTask::StartStopSpecificHostsTaskBase';

use SDB::Install::SAPInstance::TrexInstance;

sub getId {
	my ($self) = @_;
	return 'stop_instances';
}

sub getName {
	my ($self) = @_;
	return 'Stop instances';
}

sub getExecutionName {
	my ($self) = @_;
	return 'Stopping instances';
}

sub _manageSystem {
	my ($self, $hdbInstance, $userName, $password, $timeout, $useHttps) = @_;
	return $hdbInstance->stopHosts ($userName,
	                                $password,
	                                $self->getHosts(),
	                                undef, # ignore not running nodes
	                                $timeout,
	                                $useHttps);
}

1;
