package LCM::Task::TaskProgressHandler;

use strict;

sub new{
	my ($class, $task) = @_;
	my $self = bless({}, $class);
	$self->_setTask($task);
	$self->{_identationDepth} = 0;
	return $self;
}

# TODO: FIX AFTER REFACTORING END: Those two subroutines are for compatability - should be discussed

sub addLine{
	$_[0]->SetProgress($_[1]);
}

sub InitProgress ($$$$){
    my ($self,$range,$value,$steps) = @_;
    return 1;
}

sub SetProgress{
	my ($self, $progressMessage) = @_;
	my $outputHandlerKeyFound = $progressMessage =~ s/^(\s*)>/$1/;
    my $indentationDepth = $self->getIntendationDepth();
	if ($outputHandlerKeyFound or
			$progressMessage =~ /(Deployment of .* failed|Installation of|Changing listen interface|Installing|Uninstalling|Renam\w+|Updat\w+|Starting|Stopping|Restarting|Restoring|All server processes|Server processes|Importing|Loading|Uploading|Creating|Adding|Copying|Extracting|Unpacking|Configuring|Launching|Activating|Remov\w+|Registering|Unregistering|Regenerating|Deploying|Resum\w+|Prepar\w+|Finaliz\w+|Cleaning|Assigning|supported: SLES|Minimal SLES release|Downloading|Initiating|Performing|Enabling|Disabling)\s/){
		$progressMessage = ('  ' x $indentationDepth).$progressMessage;
    	$self->_getTask()->_addProgressMessage($progressMessage);
	}
}

sub _getTask{
	return $_[0]->{_task};
}

sub _setTask{
	my ($self, $task) = @_;
	$self->{_task} = $task;
}

sub getIntendationDepth {
    return shift->{_identationDepth};
}

sub setIntendationDepth {
    my ($self, $depth) = @_;
    my $oldValue = $self->{_identationDepth};
    $self->{_identationDepth} = $depth;
    return $oldValue;
}

1;