package LCM::Task::TaskProgressHandler::ComponentTaskProgressHandlerFactory;

use strict;
use warnings;
use LCM::Task::TaskProgressHandler;
use LCM::Task::TaskProgressHandler::RDSyncTaskProgressHandler;
use LCM::Task::TaskProgressHandler::ResidentInstallerTaskProgressHandler;
use SDB::Install::Globals qw ($gKeynameRDSync $gKeynameInstaller);

sub createComponentTaskProgressHandler {
    my ($task) = @_;

    my $componentKeyName = $task->getComponentKeyName();
    if(defined $componentKeyName && $componentKeyName eq $gKeynameRDSync){
        return LCM::Task::TaskProgressHandler::RDSyncTaskProgressHandler->new($task);
    } elsif (defined $componentKeyName && $componentKeyName eq $gKeynameInstaller) {
        return LCM::Task::TaskProgressHandler::ResidentInstallerTaskProgressHandler->new($task);
    } else {
        return LCM::Task::TaskProgressHandler->new($task);
    }
}

1;