package LCM::Task::TaskStatus;

use strict;
use parent qw ( Exporter );
use constant {
	INITIAL => 'slp.task.state.INITIAL',
	RUNNING => 'slp.task.state.RUNNING',
	DIALOG => 'slp.task.state.DIALOG',
	FINISHED => 'slp.task.state.FINISHED',
	ERROR => 'slp.task.state.ERROR',
	ABORTED => 'slp.task.state.ABORTED',
	# Not supported by spec. Added for convinience.
	FINISHED_WITH_WARNINGS => 'slp.task.state.FINISHED_WITH_WARNINGS'
};

our @EXPORT = qw ( INITIAL
                   RUNNING
                   DIALOG
                   FINISHED
                   ERROR
                   ABORTED
                   FINISHED_WITH_WARNINGS);
sub new {
	my ($class, $task) = @_;
	my $self = bless({}, $class);
	$self->_setTask($task);
	$self->_setInitialState();
	return $self;
}

sub getState{
	return $_[0]->{_state};
}

sub getMessage{
	my ($self, $hasWarnings) = @_;
	my $state = $self->getState();
	if($state eq FINISHED){
		if($hasWarnings) {
			return $self->_getActionDoneWithWarningsMessage();
		}
		return $self->_getActionDoneMessage();
	}
	if ($state eq ERROR){
		return $self->_getActionFailedMessage();
	}
	if ($state eq ABORTED){
		return $self->_getActionAbortedMessage();
	}
	
	return undef;
}

sub isInInitialState{
	return $_[0]->getState() eq INITIAL;
}

sub isInRunningState{
	return $_[0]->getState() eq RUNNING;
}

sub isInDialogState{
	return $_[0]->getState() eq DIALOG;
}

sub isInFinishedState{
	return $_[0]->getState() eq FINISHED;
}

sub isInErrorState{
	return $_[0]->getState() eq ERROR;
}

sub isInAbortedState{
	return $_[0]->getState() eq ABORTED;
}

sub _getTask{
	return $_[0]->{_task};
}

sub _setTask{
	my ($self, $task) = @_;
	$self->{_task} = $task;
}

sub _setInitialState{
	my $self = shift();
	$self->_getTask()->_setProgress(0);
	$self->_setState(INITIAL);
}

sub _setRunningState{
	$_[0]->_setState(RUNNING);
}

sub _setDialogState{
	$_[0]->_setState(DIALOG);
}

sub _setFinishedState{
	my $self = shift();
	$self->_getTask()->_setProgress(100);
	$self->_setState(FINISHED);
}

sub _setErrorState{
	$_[0]->_setState(ERROR);
}

sub _setAbortedState{
	$_[0]->_setState(ABORTED);
}

sub _setState{
	my ($self, $state) = @_;
	$self->{_state} = $state;
	$self->_getTask()->_notifyTaskChanged();
}

sub _getActionDoneMessage{
	return $_[0]->{_actionDoneMessage};
}

sub _setActionDoneMessage{
	my ($self, $actionDoneMessage) = @_;
	return $self->{_actionDoneMessage} = $actionDoneMessage;
}

sub _getActionDoneWithWarningsMessage{
	my $self = shift();
	if(!defined $self->{_actionDoneWithWarningsMessage}){
		return $self->_getActionDoneMessage().' with warnings';
	}
	return $self->{_actionDoneWithWarningsMessage};
}

sub _setActionDoneWithWarningsMessage{
	my ($self, $actionDoneWithWarningsMessage) = @_;
	return $self->{_actionDoneWithWarningsMessage} = $actionDoneWithWarningsMessage;
}

sub _getActionFailedMessage{
	return $_[0]->{_actionFailedMessage};
}

sub _setActionFailedMessage{
	my ($self, $actionFailedMessage) = @_;
	return $self->{_actionFailedMessage} = $actionFailedMessage;
}

sub _getActionAbortedMessage{
	return $_[0]->{_actionAbortedMessage};
}

sub _setActionAbortedMessage{
	my ($self, $actionAbortedMessage) = @_;
	return $self->{_actionAbortedMessage} = $actionAbortedMessage;
}

1;