package LCM::Utils::ComponentActionStringGenerator::Uninstall;

use strict;
use LCM::Component;
use SDB::Install::Globals qw ($gKeynameEngine $gKeynameInstaller $gKeynameSDA $gKeynameXS2 $gKeynameLSS);
use parent 'LCM::Utils::ComponentActionStringGenerator';

sub getComponentKeynameToActionMap {
    my ($self, $configuration, $componentManager, $systemComponentManager) = @_;
    my %componentKeynameToAction = ();

    foreach my $component (@{$systemComponentManager->getAllComponents()}){
        next if(!$self->_canSelectComponentForUninstallation($component, $configuration));

        my $componentName = $component->getComponentName();
        my $versionString = $component->getVersion();
        my $keyname = $component->getComponentKeyName();
        $componentKeynameToAction{$keyname} = sprintf('Uninstall %s version %s', $componentName, $versionString);
    }

    my $orderedKeynames = $self->getOrderedKeynames(\%componentKeynameToAction, $componentManager, $systemComponentManager);
    return ( $orderedKeynames, \%componentKeynameToAction );
}

sub _canSelectComponentForUninstallation {
    my ($self, $component, $configuration) = @_;
    my $componentKeyname = $component->getComponentKeyName();

    return 0 if ($componentKeyname eq $gKeynameInstaller);
    return 0 if($componentKeyname eq $gKeynameEngine);
    return 0 if($componentKeyname eq $gKeynameSDA);
    return 0 if($componentKeyname eq $gKeynameXS2 && !$component->checkVersion($configuration));
    return 0 if($componentKeyname eq $gKeynameLSS);

    return 1;
}

1;