package LCM::Utils::ComponentActionStringGenerator::WebUpdate;

use strict;
use SDB::Install::Version;
use parent 'LCM::Utils::ComponentActionStringGenerator::InstallUpdate';

sub _getComponentKeynameToPendingAction {
	my ($self, $installedComponent, $targetComponent, $configuration) = @_;
	my $pendingXmlObject = $targetComponent->getPersistenceXMLObject($configuration);
	my $sourceVersionString = $pendingXmlObject->getSourceVersionString();
	my $targetVersionString = $pendingXmlObject->getTargetVersionString();
	my $targetVersionObject = new SDB::Install::Version(split('\.', $targetVersionString));
	my $availableVersionObject = new SDB::Install::Version(split('\.', $targetComponent->getVersion()));
	my $isUpdate = ($pendingXmlObject->getActionString() =~ /update/);
	my $canResume = $availableVersionObject->isEqual($targetVersionObject);
	my $location = $targetComponent->getPath();
	my $requiresRestartMark = ($targetComponent->requireSystemRestart()) ? '*' : '';
	my $name = $targetComponent->getComponentName();

	if($canResume){
		return $isUpdate ? "Action: Resume update Name: ${name}${requiresRestartMark} VersionInfo: from version $sourceVersionString to version $targetVersionString Location: $location" :
						   "Action: Resume installation Name: ${name}${requiresRestartMark} VersionInfo: version $targetVersionString Location: $location";
	}
	# TODO Fix the case when detected version is older than the installed version
	return $isUpdate ? "Action: Update Name: ${name}${requiresRestartMark} VersionInfo: from version $sourceVersionString to version $targetVersionString Location: $location" :
					   "Action: Install Name: ${name}${requiresRestartMark} VersionInfo: version $targetVersionString Location: $location";
}

sub _getComponentKeynameToActionUpdate {
	my ($self, $installedComponent, $component) = @_;
	my $name = $component->getComponentName();
	my $installedVersion = $installedComponent->getVersion();
	my $availableVersion = $component->getVersion();
	my $location = $component->getPath();
	my $requiresRestartMark = ($component->requireSystemRestart()) ? '*' : '';
	return "Action: Update Name: ${name}${requiresRestartMark} VersionInfo: from version $installedVersion to version $availableVersion Location: $location";
}

sub _getComponentKeynameToActionInstall {
	my ($self, $component) = @_;
	my $name = $component->getComponentName();
	my $availableVersion = $component->getVersion();
	my $location = $component->getPath();
	my $requiresRestartMark = ($component->requireSystemRestart()) ? '*' : '';
	return "Action: Install Name: ${name}${requiresRestartMark} VersionInfo: version $availableVersion Location: $location";
}

sub _getComponentKeynameToActionUninstall {
	my ($self, $component) = @_;
	my $name = $component->getComponentName();
	my $installedVersion = $component->getVersion();
	my $location = $component->getPath();
	return "Action: Uninstall Name: ${name} VersionInfo: version $installedVersion Location: Installed";
}

sub _canUpgradeComponent {
	my ($self, $installedComponent, $targetComponent, $configuration) = @_;
	my $shouldIgnoreVersionChecks = $configuration->getIgnore('check_version');

	my $sourceManifest = $installedComponent->getManifest();
	my $targetManifest = $targetComponent->getManifest();
	my $msgLst = new SDB::Install::MsgLst();
	my $canUpgradeComponent = $configuration->canUpgradeComponent($sourceManifest, $targetManifest, $targetComponent->getComponentName(), $msgLst);

	if (!$canUpgradeComponent) {
		if ($shouldIgnoreVersionChecks) {
			$configuration->ResetError();
			$configuration->getMsgLst()->addMessage("Ignoring error due to command line switch '--ignore'");
			$canUpgradeComponent = 1;
		} elsif (!$targetComponent->isInternal()) {
			my $restrictedComponentMessage = $msgLst->getMsgLstString();
			$configuration->addRestrictedComponentsMessage($targetComponent->getComponentName(), $$restrictedComponentMessage);
		}
	}

	return $canUpgradeComponent;
}

1;