package LCM::Utils::XsApplicationDependency;

use strict;

sub new {
	my ($class, $caption, $technicalName, $scvVersion, $spLevel, $patchLevel) = @_;
	my $self = bless({}, $class);

	$self->setName($caption);
	$self->_setTechnicalName($technicalName);
	$self->_setScvVersion($scvVersion);
	$self->_setSpLevel($spLevel);
	$self->_setPatchLevel($patchLevel);

	return $self;
}

sub toString {
	my ($self) = @_;
	...
}

sub isSatisfied {
	my ($self, $targetComponentsHash) = @_;
	...
}

sub setName {
	my ($self, $name) = @_;
	$self->{_name} = $name;
}

sub getName {
	my ($self) = @_;
	return $self->{_name};
}

sub _setTechnicalName {
	my ($self, $technicalName) = @_;
	$self->{_technicalName} = $technicalName;
}

sub getTechnicalName {
	my ($self) = @_;
	return $self->{_technicalName};
}

sub _setScvVersion {
	my ($self, $scvVersion) = @_;
	$self->{_scvVersion} = $scvVersion;
}

sub getScvVersion {
	my ($self) = @_;
	return $self->{_scvVersion};
}

sub _setSpLevel {
	my ($self, $spLevel) = @_;
	$self->{_spLevel} = $spLevel;
}

sub getSpLevel {
	my ($self) = @_;
	return $self->{_spLevel};
}

sub _setPatchLevel {
	my ($self, $patchLevel) = @_;
	$self->{_patchLevel} = $patchLevel;
}

sub getPatchLevel {
	my ($self) = @_;
	return $self->{_patchLevel};
}

sub getVersionString {
	my ($self) = @_;
	return join('.', $self->getScvVersion, $self->getSpLevel, $self->getPatchLevel);
}

# Bring the logic for the dependecy check in the base class to avoid code duplication
sub check {
	my ($self, $targetComponentsHash) = @_;
	my $targetComponent = $targetComponentsHash->{$self->getTechnicalName()};

	return 0 if(!defined($targetComponent));

	my $wantedScvVersion = $self->getScvVersion();
	my $wantedSpLevel = $self->getSpLevel();
	my $wantedPatchLevel = $self->getPatchLevel();

	return 0 if(length($wantedScvVersion) > 0 && $wantedScvVersion != $targetComponent->getScvVersion());
	return 0 if(length($wantedSpLevel) > 0 && $wantedSpLevel > $targetComponent->getSpLevel());
	return 0 if(length($wantedPatchLevel) > 0 && $wantedSpLevel == $targetComponent->getSpLevel() && $wantedPatchLevel > $targetComponent->getPatchLevel());
	return 1;
}

1;