package LCM::Utils::XsApplicationDependency::ExclusiveDependency;

use strict;
use parent 'LCM::Utils::XsApplicationDependency';

my $DI_CORE_TECHNICAL_NAME = 'xsac_di_core';

# Override
sub isSatisfied {
	my ($self, $targetComponentsHash) = @_;
	my $technicalName = $self->getTechnicalName();
	return 1 if($DI_CORE_TECHNICAL_NAME eq $technicalName); # Bug: 127054 - let PI handle the validation for the DI_CORE

	return !$self->check($targetComponentsHash);
}

# Override
sub toString {
	my ($self) = @_;
	my $name = length($self->getName()) > 0 ? sprintf('%s (%s)', $self->getName(), $self->getTechnicalName()) : $self->getTechnicalName();
	my $scvVersion = $self->getScvVersion();
	my $spLevel = length($self->getSpLevel()) > 0 ? $self->getSpLevel() : '*';
	my $patchLevel = length($self->getPatchLevel()) > 0 ? $self->getPatchLevel() : '*';

	return sprintf('Uninstall %s version %s.%s.%s', $name, $scvVersion, $spLevel, $patchLevel);
}

1;