package LCM::Utils::XsApplicationDependency::InclusiveDependency;

use strict;
use parent 'LCM::Utils::XsApplicationDependency';

# Override
sub isSatisfied {
	my ($self, $targetComponentsHash) = @_;
	return $self->check($targetComponentsHash);
}

# Override
sub toString {
	my ($self) = @_;
	my $name = length($self->getName()) > 0 ? sprintf('%s (%s)', $self->getName(), $self->getTechnicalName()) : $self->getTechnicalName();
	my $scvVersion = $self->getScvVersion();
	my $spLevel = length($self->getSpLevel()) > 0 ? $self->getSpLevel() : '*';
	my $patchLevel = length($self->getPatchLevel()) > 0 ? $self->getPatchLevel() : '*';

	return sprintf('%s version at least %s.%s.%s', $name, $scvVersion, $spLevel, $patchLevel);
}

1;