package LCM::VerificationError;

use strict;

my $SINGLE_FAILED_AUTHENTICITY_COMPONENT_MESSAGE_FORMAT = "Authenticity verification of the %s failed. %s.";
my $SINGLE_FAILED_COMPONENT_MESSAGE_FORMAT = "Verification of the %s failed.\n %s";

my $MULTIPLE_FAILED_COMPONENTS_MESSAGE_FORMAT = " %s: %s";

sub new {
    my ($class, $componentName, $description, $isVerificationAuthenticityError) = @_;
    my $self = bless({}, $class);
    $self->_setComponentName($componentName);
    $self->_setDescription($description);
    $self->setVerificationAuthenticityError($isVerificationAuthenticityError // 1);
    return $self;
}

sub _setComponentName {
    my ($self, $name) = @_;
    $self->{componentName} = $name;
}

sub _setDescription {
    my ($self, $description) = @_;
    $self->{description} = $description;
}

sub getComponentName {
    my ($self) = @_;
    return $self->{componentName};
}

sub getDescription {
    my ($self) = @_;
    return $self->{description};
}

sub getSingleFailedComponentMessage {
    my ($self) = @_;
    my $componentName = $self->getComponentName();
    my $description = $self->getDescription();
    return $description if(!defined $componentName);
    return sprintf($SINGLE_FAILED_AUTHENTICITY_COMPONENT_MESSAGE_FORMAT, $componentName, $description) if($self->isVerificationAuthenticityError());
    return sprintf($SINGLE_FAILED_COMPONENT_MESSAGE_FORMAT, $componentName, $description);
}

sub getMultipleFailedComponentsMessage {
    my ($self) = @_;
    my $componentName = $self->getComponentName() // '';
    my $description = $self->getDescription();
    return sprintf($MULTIPLE_FAILED_COMPONENTS_MESSAGE_FORMAT, $componentName, $description);
}

sub setVerificationAuthenticityError{
    my($self, $value) = @_;
    $self->{_isVerificationAuthenticityError} = $value;
}

sub isVerificationAuthenticityError{
    my($self) = @_;
    return $self->{_isVerificationAuthenticityError};
}

1;