package SAPDB::Install::Window::DBUserSimple;

use Wx qw(wxVERTICAL wxALL wxEXPAND
		wxLEFT wxRIGHT wxTE_PASSWORD
		wxTOP wxHORIZONTAL
		wxALIGN_CENTER_VERTICAL wxFLEX_GROWMODE_NONE);
our @ISA = qw (Wx::Panel);

use SDB::Install::Gui::Design;
use SDB::Install::Gui::Control::Label;


sub new{
	my $class = shift;
	my $self = $class->SUPER::new(@_);
	
	if ($^O !~ /mswin/i){
		$self->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);
	}
		my $sizer = Wx::FlexGridSizer->new(3,2,5,20);
		$sizer->SetFlexibleDirection (wxHORIZONTAL);
		$sizer->SetNonFlexibleGrowMode (wxFLEX_GROWMODE_NONE);
        $self->{'label_user'} = SDB::Install::Gui::Control::Label->new($self,-1,'User Name',1);
        $self->{'label_passwd'} = SDB::Install::Gui::Control::Label->new($self,-1,'Password',1);
        $self->{'label_confirm_passwd'} = SDB::Install::Gui::Control::Label->new($self,-1,'Password Confirmation',1);
        $self->{'ctrl_user'} = Wx::TextCtrl->new($self,-1,'',[0,0],[160,-1]);
        $self->{'ctrl_passwd'} = Wx::TextCtrl->new($self,-1,
                                        '',[0,0],[160,-1],wxTE_PASSWORD);
        $self->{'ctrl_passwd'}->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
        $self->{'ctrl_confirm_passwd'} = Wx::TextCtrl->new($self,-1,
                                        '',[0,0],[160,-1],wxTE_PASSWORD);
        $self->{'ctrl_confirm_passwd'}->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
        $sizer->Add($self->{'label_user'},0, wxALIGN_CENTER_VERTICAL);
        $sizer->Add($self->{'ctrl_user'},0, wxALIGN_CENTER_VERTICAL);
        $sizer->Add($self->{'label_passwd'},0, wxALIGN_CENTER_VERTICAL);
        $sizer->Add($self->{'ctrl_passwd'},0, wxALIGN_CENTER_VERTICAL);
        $sizer->Add($self->{'label_confirm_passwd'},0, wxALIGN_CENTER_VERTICAL);
        $sizer->Add($self->{'ctrl_confirm_passwd'},0, wxALIGN_CENTER_VERTICAL);
        $self->SetSizerAndFit($sizer);
        $self->{flex_sizer} =  $sizer;
	return $self;
}

sub setColSize{
	my ($self, $size) = @_;
	
	my ($x1,$y1) = $self->{'label_passwd'}->GetPositionXY();
	my ($x2,$y2) = $self->{'ctrl_passwd'}->GetPositionXY();
	
	my $w = $x2 - $x1;

	if ($w < $size){
		$self->GetSizer->SetHGap($size - $w + $self->GetSizer->GetHGap);
		$self->GetSizer->Layout();
	}
	$self->SetSizerAndFit($self->GetSizer);
}

sub SetValue{
	my ($self,$user) = @_;
	$self->{'ctrl_user'}->SetValue($user->{'Name'});
	$self->{'ctrl_passwd'}->SetValue(defined $user->{'Password'} ? $user->{'Password'} : '');
	$self->{'ctrl_confirm_passwd'}->SetValue(defined $user->{'ConfirmPassword'} ? $user->{'ConfirmPassword'} : '');
	return 1;
}

sub GetValue{
	my ($self) = @_; 
	my %user;
	$user{'Name'} = $self->{'ctrl_user'}->GetValue;
	$user{'Password'} = $self->{'ctrl_passwd'}->GetValue;
	$user{'ConfirmPassword'} = $self->{'ctrl_confirm_passwd'}->GetValue;
	return \%user; 
}

sub Destroy{
	my ($self) = @_;
	$self->GetSizer->Clear (1);
	if(defined $self->{'label_user'}){
		delete $self->{'label_user'};	
	}
	if(defined $self->{'label_passwd'}){
		delete $self->{'label_passwd'};
	}
	if(defined $self->{'label_confirm_passwd'}){
		delete $self->{'label_confirm_passwd'};
	}
	if(defined $self->{'ctrl_user'}){
		delete $self->{'ctrl_user'};
	}
	if(defined $self->{'ctrl_passwd'}){
		delete $self->{'ctrl_passwd'};
	}
	if($self->{'ctrl_confirm_passwd'}){
		delete $self->{'ctrl_confirm_passwd'};		
	}	
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if defined $SAPDB::Install::DEBUG::DESTRUCT &&
			$SAPDB::Install::DEBUG::DESTRUCT;
}


1;
