package SAPDB::Install::Window::ExecPlan;

use Wx qw(wxEXPAND wxVERTICAL wxSUNKEN_BORDER wxWHITE
		 wxALIGN_CENTER_VERTICAL wxVSCROLL wxALL);

use SAPDB::Install::Resources;
use SDB::Install::Gui::Design;
use strict;

our @ISA = qw(Wx::ScrolledWindow);

sub new{
	my ($self) = shift->SUPER::new(@_,[-1,-1],[-1,-1],wxSUNKEN_BORDER);
	$self->SetBackgroundColour (wxWHITE);
	$self->{bmps} = {};
	my $imgs = new SAPDB::Install::Resources()->getImages ('icon/ready.png','icon/process.png','icon/error.png');
	if (defined $imgs){
		$self->{bmps}->{'RUNNING'} = Wx::Bitmap->new ($imgs->{'icon/process.png'});
		$self->{bmps}->{'FINISHED_SUCCESS'} = Wx::Bitmap->new ($imgs->{'icon/ready.png'});
		$self->{bmps}->{'FINISHED_ERROR'} = Wx::Bitmap->new ($imgs->{'icon/error.png'});
	}
	else{
		die ("resource error: cannot get images\n");
	}	
	return $self;
}

sub init{
	my ($self,$plannedTasks,$configuration) = @_;
	return if(@{$plannedTasks} == 0 );
	$self->{plannedTasks} = $plannedTasks;
	delete $self->{'current_step'};
	delete $self->{'done'};
	$self->{'config'} = $configuration;
	my $sizer = Wx::FlexGridSizer->new (scalar @$plannedTasks, 3, 10, 5);
	$sizer->AddGrowableCol (2);
	
	my $row = 0;
	my @rows;
	my $first = 1;
	foreach my $task (@$plannedTasks){
		my $row = {};		
		$row->{'bmp'} = Wx::StaticBitmap->new($self,-1,$self->{'bmps'}->{'RUNNING'});
		if ($first){
			$first = 0;
		}
		else{ 
			$row->{'bmp'}->Show (0);
		}
		$sizer->Add ($row->{'bmp'},0,wxALIGN_CENTER_VERTICAL);
		$row->{'label'} = Wx::StaticText->new($self,-1,$task->{'Label'});
		$row->{'label'}->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
		$sizer->Add ($row->{'label'},0,wxALIGN_CENTER_VERTICAL);
		if($configuration->{'with_progress'}){
			$row->{'gauge'} = Wx::Gauge->new ($self, -1, 100, [-1,-1], [150,15]);
			$sizer->Add ($row->{'gauge'},1,wxEXPAND | wxALIGN_CENTER_VERTICAL);
		}
		else{
			$sizer->AddStretchSpacer (1);
		}
		push @rows,$row;
	}
	$self->SetScrollRate(0,5);
	$self->{rows} = \@rows;
	my $top_sizer = Wx::BoxSizer->new (wxVERTICAL);
	
	$top_sizer->Add($sizer,1,wxEXPAND | wxALL, 10);
	$self->Next ();
	$self->SetSizer ($top_sizer);
	$self->SetAutoLayout (1);
	$self->Layout ();
	return 1;
}


sub IsCurrentStepVisible{
	my ($self) = @_;
	
	my ($scrollx_unit,$scrolly_unit) = $self->GetScrollPixelsPerUnit ();
	my $cur_pos = $self->{rows}->[$self->{'current_step'}]->{bmp}->GetPosition();
	my ($cur_pos_x,$cur_pos_y) = $self->CalcUnscrolledPosition($cur_pos->x,$cur_pos->y);
	my ($start_x,$start_y) = $self->GetViewStart ();
	
	$start_y *=  $scrolly_unit;
	
	if ($cur_pos->y < $cur_pos_y){
		return 0;
	}	
	
	
	#my ($width,$height) = $self->GetSizeWH ();
	my ($width,$height) = $self->GetClientSize ();
    if (!defined $height){
        $height = 0;
    }
	if ($cur_pos_y  + 30 > $start_y + $height){
		return 0;
	}	
	return 1;
}

sub ScrollToCurrentStep{
	my ($self) = @_;
	my ($scrollx_unit,$scrolly_unit) = $self->GetScrollPixelsPerUnit ();
	my $cur_pos = $self->{rows}->[$self->{'current_step'}]->{label}->GetPosition();
	
	my ($cur_pos_x,$cur_pos_y) = $self->CalcUnscrolledPosition($cur_pos->x,$cur_pos->y);
	my ($start_x,$start_y) = $self->GetViewStart ();
	
	$start_y *=  $scrolly_unit;
	
	if ($cur_pos_y < $start_y){
		$self->Scroll (0,$cur_pos->y / $scrolly_unit);
		return 0;
	}	
	
	my ($width,$height) = $self->GetSizeWH ();
	
	if ($cur_pos_y + 30 > $start_y + $height){
		my $val = int (($cur_pos_y + 30  - $height) / $scrolly_unit);
		$self->Scroll (-1,$val);
		return 0;
	}	
	return 1;
}


sub Next{
	my ($self,$state) = @_;
	return unless defined $self->{plannedTasks};
	return if $self->{'done'};	
	unless(exists $self->{'current_step'}){
		$self->{'current_step'} = 0;	
		$self->{rows}->[0]->{bmp}->Show (1);
		return 1;
	}
	
	if($self->{'current_step'} > (scalar @{$self->{rows}})){
		$self->{rows}->[$self->{'current_step'}]->{bmp}->SetBitmap($self->{bmps}->{$state});
		$self->{'done'} = 1;
		return;
	}
	
	$self->{rows}->[$self->{current_step}++]->{bmp}->SetBitmap($self->{bmps}->{$state});	
	my $last_row = scalar @{$self->{rows}} - 1;
	
	if ($self->{'current_step'} <= $last_row){
		$self->{rows}->[$self->{'current_step'}]->{bmp}->Show (1);
	}
	else{
		$self->{current_step} = $last_row;
	}
	unless ($self->IsCurrentStepVisible ()){
		$self->ScrollToCurrentStep ();
		
	}
	Wx::Yield ();
	return 1;
}


sub SetProgress{
	my ($self,$value) = @_;
	if ($value > 100){
		$value = 100;
	}
	
	$self->{rows}->[$self->{current_step}]->{gauge}->SetValue ($value);
	Wx::Yield ();
}

sub Destroy{
	my ($self) = @_;
	my $sizer = $self->GetSizer();
	if (defined $sizer){
		$sizer->Clear (1);
	}
	$self->SUPER::Destroy;
}


sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if defined $SAPDB::Install::DEBUG::DESTRUCT &&
			$SAPDB::Install::DEBUG::DESTRUCT;
}


1;
